/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import java.io.Serializable;

public abstract class Equivalence {
    protected abstract int doHash(Object var1);

    public final int hash(Object object) {
        if (object == null) {
            return 0;
        }
        return this.doHash(object);
    }

    public static Equivalence equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence identity() {
        return Identity.INSTANCE;
    }

    protected Equivalence() {
    }

    protected abstract boolean doEquivalent(Object var1, Object var2);

    public final boolean equivalent(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return this.doEquivalent(object, object2);
    }

    static final class Equals
    extends Equivalence
    implements Serializable {
        static final Equals INSTANCE;
        private static final long serialVersionUID = 1L;

        @Override
        protected int doHash(Object object) {
            return object.hashCode();
        }

        private Object readResolve() {
            return INSTANCE;
        }

        static {
            Equals equals;
            INSTANCE = equals = new Equals();
        }

        Equals() {
        }

        @Override
        protected boolean doEquivalent(Object object, Object object2) {
            return object.equals(object2);
        }
    }

    static final class Identity
    extends Equivalence
    implements Serializable {
        static final Identity INSTANCE;
        private static final long serialVersionUID = 1L;

        @Override
        protected int doHash(Object object) {
            return System.identityHashCode(object);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        static {
            Identity identity;
            INSTANCE = identity = new Identity();
        }

        Identity() {
        }

        @Override
        protected boolean doEquivalent(Object object, Object object2) {
            return false;
        }
    }
}

