/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Platform;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Ticker;
import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    private final Ticker ticker = Ticker.systemTicker();
    private boolean isRunning;
    private long elapsedNanos;
    private long startTick;

    public long elapsed(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long elapsedNanos() {
        if (!this.isRunning) return this.elapsedNanos;
        return this.ticker.read() - this.startTick + this.elapsedNanos;
    }

    public static Stopwatch createUnstarted() {
        Stopwatch stopwatch = new Stopwatch();
        return stopwatch;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Stopwatch start() {
        boolean bl = !this.isRunning;
        Preconditions.checkState(bl, "This stopwatch is already running.");
        this.isRunning = true;
        this.startTick = this.ticker.read();
        return this;
    }

    private static String abbreviate(TimeUnit object) {
        switch (1.$SwitchMap$java$util$concurrent$TimeUnit[object.ordinal()]) {
            default: {
                object = new AssertionError();
                throw object;
            }
            case 7: {
                return "d";
            }
            case 6: {
                return "h";
            }
            case 5: {
                return "min";
            }
            case 4: {
                return "s";
            }
            case 3: {
                return "ms";
            }
            case 2: {
                return "\u03bcs";
            }
            case 1: 
        }
        return "ns";
    }

    public String toString() {
        long l = object.elapsedNanos();
        Object object = Stopwatch.chooseUnit(l);
        Object object2 = TimeUnit.NANOSECONDS;
        long l2 = ((TimeUnit)((Object)object2)).convert(1L, (TimeUnit)((Object)object));
        object2 = new StringBuilder();
        return ((StringBuilder)object2).append(Platform.formatCompact4Digits((double)l / (double)l2)).append(" ").append(Stopwatch.abbreviate((TimeUnit)((Object)object))).toString();
    }

    private static TimeUnit chooseUnit(long l) {
        if (TimeUnit.DAYS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    Stopwatch() {
    }
}

