/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Objects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.CollectPreconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.core.internal.deps.guava.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;

public final class Lists {
    static int computeArrayListCapacity(int n) {
        CollectPreconditions.checkNonnegative(n, "arraySize");
        return Ints.saturatedCast((long)n + 5L + (long)(n / 10));
    }

    static int indexOfImpl(List object, Object object2) {
        if (object instanceof RandomAccess) {
            return Lists.indexOfRandomAccess((List)object, object2);
        }
        object = object.listIterator();
        while (object.hasNext()) {
            if (!Objects.equal(object2, object.next())) continue;
            return object.previousIndex();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int indexOfRandomAccess(List list, Object object) {
        int n = list.size();
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (list.get(i) != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (!object.equals(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    static int lastIndexOfImpl(List object, Object object2) {
        if (object instanceof RandomAccess) {
            return Lists.lastIndexOfRandomAccess((List)object, object2);
        }
        object = object.listIterator(object.size());
        while (object.hasPrevious()) {
            if (!Objects.equal(object2, object.previous())) continue;
            return object.nextIndex();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int lastIndexOfRandomAccess(List list, Object object) {
        if (object == null) {
            for (int i = list.size() + -1; i >= 0; --i) {
                if (list.get(i) != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = list.size() + -1; i >= 0; --i) {
            if (!object.equals(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList newArrayList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList newArrayList(Iterable arrayList) {
        Preconditions.checkNotNull(arrayList);
        if (!(arrayList instanceof Collection)) return Lists.newArrayList(arrayList.iterator());
        ArrayList arrayList2 = new ArrayList(arrayList);
        return arrayList2;
    }

    public static ArrayList newArrayList(Iterator iterator) {
        ArrayList arrayList = Lists.newArrayList();
        Iterators.addAll(arrayList, iterator);
        return arrayList;
    }

    @SafeVarargs
    public static ArrayList newArrayList(Object ... objectArray) {
        Preconditions.checkNotNull(objectArray);
        int n = objectArray.length;
        n = Lists.computeArrayListCapacity(n);
        ArrayList arrayList = new ArrayList(n);
        Collections.addAll(arrayList, objectArray);
        return arrayList;
    }

    public static ArrayList newArrayListWithCapacity(int n) {
        CollectPreconditions.checkNonnegative(n, "initialArraySize");
        ArrayList arrayList = new ArrayList(n);
        return arrayList;
    }

    public static LinkedList newLinkedList() {
        LinkedList linkedList = new LinkedList();
        return linkedList;
    }

    static boolean equalsImpl(List list, Object object) {
        if (object == Preconditions.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list2 = (List)object;
        int n = list.size();
        if (n != list2.size()) {
            return false;
        }
        if (list instanceof RandomAccess && list2 instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                if (Objects.equal(list.get(i), list2.get(i))) continue;
                return false;
            }
            return true;
        }
        return Iterators.elementsEqual(list.iterator(), list2.iterator());
    }
}

