/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.FluentFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.Platform;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

abstract class AbstractTransformFuture
extends FluentFuture.TrustedFuture
implements Runnable {
    ListenableFuture inputFuture;
    Object function;

    static ListenableFuture create(ListenableFuture listenableFuture, Function function, Executor executor) {
        Preconditions.checkNotNull(function);
        TransformFuture transformFuture = new TransformFuture(listenableFuture, function);
        listenableFuture.addListener((Runnable)transformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, transformFuture));
        return transformFuture;
    }

    abstract Object doTransform(Object var1, Object var2) throws Exception;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected String pendingToString() {
        Object object;
        Object object2 = ((AbstractTransformFuture)object).inputFuture;
        Object object3 = ((AbstractTransformFuture)object).function;
        String string = super.pendingToString();
        if (object2 != null) {
            object = new StringBuilder();
            object = ((StringBuilder)object).append("inputFuture=[").append(object2).append("], ").toString();
        } else {
            object = "";
        }
        if (object3 != null) {
            object2 = new StringBuilder();
            return ((StringBuilder)object2).append((String)object).append("function=[").append(object3).append("]").toString();
        }
        if (string != null) {
            object2 = new StringBuilder();
            return ((StringBuilder)object2).append((String)object).append(string).toString();
        }
        return null;
    }

    AbstractTransformFuture(ListenableFuture listenableFuture, Object object) {
        this.inputFuture = (ListenableFuture)Preconditions.checkNotNull(listenableFuture);
        this.function = Preconditions.checkNotNull(object);
    }

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo((Future)this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        Object object;
        Object object2;
        block12: {
            ListenableFuture listenableFuture = this.inputFuture;
            object2 = this.function;
            boolean bl = this.isCancelled();
            boolean bl2 = listenableFuture == null;
            if ((bl |= bl2) | (bl2 = object2 == null)) {
                return;
            }
            this.inputFuture = null;
            if (listenableFuture.isCancelled()) {
                this.setFuture(listenableFuture);
                return;
            }
            object = Futures.getDone((Future)listenableFuture);
            try {}
            catch (Throwable throwable) {
                try {
                    Platform.restoreInterruptIfIsInterruptedException(throwable);
                    this.setException(throwable);
                    return;
                }
                finally {
                    this.function = null;
                }
            }
            break block12;
            catch (CancellationException cancellationException) {
                this.cancel(false);
                return;
            }
            catch (ExecutionException executionException) {
                this.setException(executionException.getCause());
                return;
            }
            catch (RuntimeException runtimeException) {
                this.setException(runtimeException);
                return;
            }
            catch (Error error) {
                this.setException(error);
                return;
            }
        }
        object = this.doTransform(object2, object);
        this.function = null;
        this.setResult(object);
    }

    abstract void setResult(Object var1);

    private static final class TransformFuture
    extends AbstractTransformFuture {
        Object doTransform(Function function, Object object) {
            return function.apply(object);
        }

        TransformFuture(ListenableFuture listenableFuture, Function function) {
            super(listenableFuture, function);
        }

        @Override
        void setResult(Object object) {
            this.set(object);
        }
    }
}

