/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.view.View;
import android.widget.TextView;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class LayoutMatchers {
    public static Matcher<View> hasEllipsizedText() {
        TypeSafeMatcher<View> typeSafeMatcher = new TypeSafeMatcher<View>(TextView.class){
            {
                void var1_1;
            }

            public void describeTo(Description description) {
                description.appendText("has ellipsized text");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean matchesSafely(View tv) {
                1 this_ = ((TextView)tv).getLayout();
                if (this_ == null) return false;
                int n = this_.getLineCount();
                if (n <= 0) return false;
                if (this_.getEllipsisCount(n + -1) <= 0) return false;
                return true;
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<View> hasMultilineText() {
        TypeSafeMatcher<View> typeSafeMatcher = new TypeSafeMatcher<View>(TextView.class){
            {
                void var1_1;
            }

            public void describeTo(Description description) {
                description.appendText("has more than one line of text");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean matchesSafely(View tv) {
                if (((TextView)tv).getLineCount() <= 1) return false;
                return true;
            }
        };
        return typeSafeMatcher;
    }

    private LayoutMatchers() {
    }
}

