/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.res.Resources;
import android.preference.Preference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class PreferenceMatchers {
    public static Matcher<Preference> isEnabled() {
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            public void describeTo(Description description) {
                description.appendText(" is an enabled preference");
            }

            public boolean matchesSafely(Preference pref) {
                return pref.isEnabled();
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withKey(String key) {
        return PreferenceMatchers.withKey((Matcher<String>)Matchers.is((Object)key));
    }

    public static Matcher<Preference> withKey(Matcher<String> keyMatcher) {
        Matcher<String> matcher;
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            /*
             * WARNING - void declaration
             */
            public void describeTo(Description description) {
                void var1_1;
                description.appendText(" preference with key matching: ");
                matcher.describeTo((Description)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public boolean matchesSafely(Preference pref) {
                void var1_1;
                return matcher.matches((Object)var1_1.getKey());
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withSummary(int resourceId) {
        int n;
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            /*
             * WARNING - void declaration
             */
            public void describeTo(Description description) {
                void var1_1;
                description.appendText(" with summary string from resource id: ");
                var1_1.appendValue((Object)n);
                if (this.resourceName != null) {
                    var1_1.appendText("[");
                    var1_1.appendText(this.resourceName);
                    var1_1.appendText("]");
                }
                if (this.expectedText != null) {
                    var1_1.appendText(" value: ");
                    var1_1.appendText(this.expectedText);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean matchesSafely(Preference preference) {
                void var1_1;
                if (this.expectedText == null) {
                    try {
                        this.expectedText = var1_1.getContext().getResources().getString(n);
                        this.resourceName = var1_1.getContext().getResources().getResourceEntryName(n);
                    }
                    catch (Resources.NotFoundException notFoundException) {}
                }
                if (this.expectedText != null) {
                    return this.expectedText.equals(var1_1.getSummary().toString());
                }
                return false;
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withSummaryText(String summary) {
        return PreferenceMatchers.withSummaryText((Matcher<String>)Matchers.is((Object)summary));
    }

    public static Matcher<Preference> withSummaryText(Matcher<String> summaryMatcher) {
        Matcher<String> matcher;
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            /*
             * WARNING - void declaration
             */
            public void describeTo(Description description) {
                void var1_1;
                description.appendText(" a preference with summary matching: ");
                matcher.describeTo((Description)var1_1);
            }

            public boolean matchesSafely(Preference pref) {
                CharSequence charSequence = pref.getSummary();
                charSequence = charSequence.toString();
                return matcher.matches((Object)charSequence);
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withTitle(int resourceId) {
        int n;
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){
            private String resourceName = null;
            private String expectedText = null;

            /*
             * WARNING - void declaration
             */
            public void describeTo(Description description) {
                void var1_1;
                description.appendText(" with title string from resource id: ");
                var1_1.appendValue((Object)n);
                if (this.resourceName != null) {
                    var1_1.appendText("[");
                    var1_1.appendText(this.resourceName);
                    var1_1.appendText("]");
                }
                if (this.expectedText != null) {
                    var1_1.appendText(" value: ");
                    var1_1.appendText(this.expectedText);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean matchesSafely(Preference preference) {
                void var1_1;
                if (this.expectedText == null) {
                    try {
                        this.expectedText = var1_1.getContext().getResources().getString(n);
                        this.resourceName = var1_1.getContext().getResources().getResourceEntryName(n);
                    }
                    catch (Resources.NotFoundException notFoundException) {}
                }
                if (this.expectedText != null && var1_1.getTitle() != null) {
                    return this.expectedText.equals(var1_1.getTitle().toString());
                }
                return false;
            }
        };
        return typeSafeMatcher;
    }

    public static Matcher<Preference> withTitleText(String title) {
        return PreferenceMatchers.withTitleText((Matcher<String>)Matchers.is((Object)title));
    }

    public static Matcher<Preference> withTitleText(Matcher<String> titleMatcher) {
        Matcher<String> matcher;
        TypeSafeMatcher<Preference> typeSafeMatcher = new TypeSafeMatcher<Preference>(){

            /*
             * WARNING - void declaration
             */
            public void describeTo(Description description) {
                void var1_1;
                description.appendText(" a preference with title matching: ");
                matcher.describeTo((Description)var1_1);
            }

            public boolean matchesSafely(Preference pref) {
                CharSequence charSequence;
                if (pref.getTitle() == null) {
                    return false;
                }
                charSequence = charSequence.getTitle();
                charSequence = charSequence.toString();
                return matcher.matches((Object)charSequence);
            }
        };
        return typeSafeMatcher;
    }

    private PreferenceMatchers() {
    }
}

