/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.app.Activity;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.Root;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RootMatchers {
    private static final String TAG = "RootMatchers";
    public static final Matcher<Root> DEFAULT = Matchers.allOf(RootMatchers.hasWindowLayoutParams(), (Matcher)Matchers.allOf((Matcher)Matchers.anyOf((Matcher)Matchers.allOf(RootMatchers.isDialog(), RootMatchers.withDecorView(RootMatchers.hasWindowFocus())), RootMatchers.isSubwindowOfCurrentActivity()), RootMatchers.isFocusable()));

    private static List<IBinder> getResumedActivityTokens() {
        Object object = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        if (object.isEmpty()) {
            Log.w((String)TAG, (String)"suppressed: NoActivityResumedException(\"At least one activity should be in RESUMED stage.\"");
        }
        ArrayList arrayList = Lists.newArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(((Activity)object.next()).getWindow().getDecorView().getApplicationWindowToken());
        }
        return arrayList;
    }

    private static Matcher<View> hasWindowFocus() {
        HasWindowFocus hasWindowFocus = new HasWindowFocus();
        return hasWindowFocus;
    }

    public static Matcher<Root> hasWindowLayoutParams() {
        HasWindowLayoutParams hasWindowLayoutParams = new HasWindowLayoutParams();
        return hasWindowLayoutParams;
    }

    public static Matcher<Root> isDialog() {
        IsDialog isDialog = new IsDialog();
        return isDialog;
    }

    public static Matcher<Root> isFocusable() {
        IsFocusable isFocusable = new IsFocusable();
        return isFocusable;
    }

    public static Matcher<Root> isPlatformPopup() {
        IsPlatformPopup isPlatformPopup = new IsPlatformPopup();
        return isPlatformPopup;
    }

    private static Matcher<Root> isSubwindowOfCurrentActivity() {
        IsSubwindowOfCurrentActivity isSubwindowOfCurrentActivity = new IsSubwindowOfCurrentActivity();
        return isSubwindowOfCurrentActivity;
    }

    public static Matcher<Root> isSystemAlertWindow() {
        IsSystemAlertWindow isSystemAlertWindow = new IsSystemAlertWindow();
        return isSystemAlertWindow;
    }

    public static Matcher<Root> isTouchable() {
        IsTouchable isTouchable = new IsTouchable();
        return isTouchable;
    }

    public static Matcher<Root> withDecorView(Matcher<View> decorViewMatcher) {
        Matcher<View> matcher;
        Preconditions.checkNotNull(decorViewMatcher);
        WithDecorView withDecorView = new WithDecorView(matcher);
        return withDecorView;
    }

    private RootMatchers() {
    }

    static final class IsFocusable
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsFocusable() {
        }

        public void describeTo(Description description) {
            description.appendText("is focusable");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(Root root) {
            if ((root.getWindowLayoutParams().get().flags & 8) == 8) return false;
            return true;
        }
    }

    static final class IsTouchable
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsTouchable() {
        }

        public void describeTo(Description description) {
            description.appendText("is touchable");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(Root root) {
            if ((root.getWindowLayoutParams().get().flags & 0x10) == 16) return false;
            return true;
        }
    }

    static final class IsDialog
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsDialog() {
        }

        public void describeTo(Description description) {
            description.appendText("is dialog");
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchesSafely(Root root) {
            void var1_2;
            int n = root.getWindowLayoutParams().get().type;
            return n != 1 && n < 99 && var1_2.getDecorView().getWindowToken() == var1_2.getDecorView().getApplicationWindowToken();
        }
    }

    static final class IsSystemAlertWindow
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsSystemAlertWindow() {
        }

        public void describeTo(Description description) {
            description.appendText("is system alert window");
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchesSafely(Root root) {
            void var1_2;
            int n = root.getWindowLayoutParams().get().type;
            return n > 2000 && n < 2999 && var1_2.getDecorView().getWindowToken() == var1_2.getDecorView().getApplicationWindowToken();
        }
    }

    static final class IsPlatformPopup
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsPlatformPopup() {
        }

        public void describeTo(Description description) {
            description.appendText("with decor view of type PopupWindow$PopupViewContainer");
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean matchesSafely(Root item) {
            void var1_4;
            void var0_2;
            if (Build.VERSION.SDK_INT < 23) return RootMatchers.withDecorView(ViewMatchers.withClassName((Matcher<String>)Matchers.is((Object)var0_2))).matches((Object)var1_4);
            return RootMatchers.withDecorView(ViewMatchers.withClassName((Matcher<String>)Matchers.is((Object)var0_2))).matches((Object)var1_4);
        }
    }

    static final class WithDecorView
    extends TypeSafeMatcher<Root> {
        @RemoteMsgField(order=0)
        private final Matcher<View> decorViewMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        public WithDecorView(Matcher<View> decorViewMatcher) {
            void var1_1;
            this.decorViewMatcher = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            description.appendText("with decor view ");
            this.decorViewMatcher.describeTo((Description)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchesSafely(Root root) {
            void var1_1;
            return this.decorViewMatcher.matches((Object)var1_1.getDecorView());
        }
    }

    static final class HasWindowFocus
    extends TypeSafeMatcher<View> {
        @RemoteMsgConstructor
        public HasWindowFocus() {
        }

        public void describeTo(Description description) {
            description.appendText("has window focus");
        }

        public boolean matchesSafely(View view) {
            return view.hasWindowFocus();
        }
    }

    static final class HasWindowLayoutParams
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public HasWindowLayoutParams() {
        }

        public void describeTo(Description description) {
            description.appendText("has window layout params");
        }

        public boolean matchesSafely(Root root) {
            return root.getWindowLayoutParams().isPresent();
        }
    }

    static final class IsSubwindowOfCurrentActivity
    extends TypeSafeMatcher<Root> {
        @RemoteMsgConstructor
        public IsSubwindowOfCurrentActivity() {
        }

        public void describeTo(Description description) {
            description.appendText("is subwindow of current activity");
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchesSafely(Root root) {
            void var1_1;
            return RootMatchers.getResumedActivityTokens().contains(var1_1.getDecorView().getApplicationWindowToken());
        }
    }
}

