/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.screenshot;

import android.graphics.Bitmap;
import androidx.test.annotation.ExperimentalTestApi;
import androidx.test.espresso.IdlingPolicies;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.SettableFuture;
import androidx.test.espresso.screenshot.CaptureImageException;
import androidx.test.espresso.screenshot.ImageCaptureViewAction;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u00a8\u0006\u0003"}, d2={"captureToBitmap", "Landroid/graphics/Bitmap;", "Landroidx/test/espresso/ViewInteraction;", "androidx.test.espresso.screenshot"})
@JvmName(name="ViewInteractionCapture")
public final class ViewInteractionCapture {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ExperimentalTestApi
    public static final Bitmap captureToBitmap(ViewInteraction $this$captureToBitmap) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        Object object2 = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create<Bitmap>()");
        ViewAction[] viewActionArray = new ViewAction[1];
        ImageCaptureViewAction imageCaptureViewAction = new ImageCaptureViewAction((SettableFuture<Bitmap>)object2);
        viewActionArray[0] = imageCaptureViewAction;
        ((ViewInteraction)object).perform(viewActionArray);
        try {
            object = ((AbstractFuture.TrustedFuture)object2).get(IdlingPolicies.getMasterIdlingPolicy().getIdleTimeout(), IdlingPolicies.getMasterIdlingPolicy().getIdleTimeoutUnit());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bitmapFuture[\n      Idli\u2026Policy().idleTimeoutUnit]");
            return (Bitmap)object;
        }
        catch (TimeoutException timeoutException) {
            object2 = new CaptureImageException("failed to capture image", timeoutException);
            throw object2;
        }
        catch (InterruptedException interruptedException) {
            object2 = new CaptureImageException("failed to capture image", interruptedException);
            throw object2;
        }
        catch (ExecutionException executionException) {
            object2 = new CaptureImageException("failed to capture image", executionException);
            throw object2;
        }
    }
}

