/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.content.res.Resources;
import android.database.Cursor;
import android.os.Build;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.util.TreeIterables;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HumanReadables {
    private static final String JAVA_ID = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern OBJECT_HASH_CODE_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*@([0-9A-Fa-f]+)");

    /*
     * Unable to fully structure code
     */
    public static String describe(Cursor c) {
        if (c.isBeforeFirst()) {
            return "Cursor positioned before first element.";
        }
        if (var0.isAfterLast()) {
            return "Cursor positioned after last element.";
        }
        var1_1 = new StringBuilder("Row ");
        var3_3 = var1_1.append(var0.getPosition()).append(": {");
        var4_4 = var0.getColumnNames();
        block7: for (var1_2 = 0; var1_2 < var4_4.length; ++var1_2) {
            block13: {
                var3_3.append(var4_4[var1_2]).append(":");
                if (Build.VERSION.SDK_INT <= 10) break block13;
                switch (var0.getType(var1_2)) {
                    default: {
                        var3_3.append("\"").append(var0.getString(var1_2)).append("\"");
lbl16:
                        // 6 sources

                        while (true) {
                            var3_3.append(", ");
                            continue block7;
                            break;
                        }
                    }
                    case 4: {
                        var5_6 = var0.getBlob(var1_2);
                        var3_3.append("[");
                        for (var2_5 = 0; var2_5 < 5 && var2_5 < var5_6.length; ++var2_5) {
                            var3_3.append(var5_6[var2_5]);
                            var3_3.append(",");
                        }
                        if (var5_6.length > 5) {
                            var3_3.append("... (").append(var5_6.length + -5).append(" more elements)");
                        }
                        var3_3.append("]");
                        ** GOTO lbl16
                    }
                    case 2: {
                        var3_3.append(var0.getDouble(var1_2));
                        var3_3.append("f");
                        ** GOTO lbl16
                    }
                    case 1: {
                        var3_3.append(var0.getLong(var1_2));
                        ** GOTO lbl16
                    }
                    case 0: {
                        var3_3.append("null");
                        ** GOTO lbl16
                    }
                    case 3: 
                }
            }
            var3_3.append("\"").append(var0.getString(var1_2)).append("\"");
            ** continue;
        }
        var3_3.append("}");
        return var3_3.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String describe(View v) {
        EditorInfo editorInfo;
        View view;
        if (v == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(view).add("id", view.getId());
        if (view.getId() != -1 && view.getResources() != null && !HumanReadables.isViewIdGenerated(view.getId())) {
            try {
                toStringHelper.add("res-name", view.getResources().getResourceEntryName(view.getId()));
            }
            catch (Resources.NotFoundException notFoundException) {}
        }
        if (view.getContentDescription() != null) {
            toStringHelper.add("desc", view.getContentDescription());
        }
        switch (view.getVisibility()) {
            default: {
                toStringHelper.add("visibility", view.getVisibility());
                break;
            }
            case 8: {
                toStringHelper.add("visibility", "GONE");
                break;
            }
            case 4: {
                toStringHelper.add("visibility", "INVISIBLE");
                break;
            }
            case 0: {
                toStringHelper.add("visibility", "VISIBLE");
            }
        }
        toStringHelper.add("width", view.getWidth()).add("height", view.getHeight()).add("has-focus", view.hasFocus()).add("has-focusable", view.hasFocusable()).add("has-window-focus", view.hasWindowFocus()).add("is-clickable", view.isClickable()).add("is-enabled", view.isEnabled()).add("is-focused", view.isFocused()).add("is-focusable", view.isFocusable()).add("is-layout-requested", view.isLayoutRequested()).add("is-selected", view.isSelected()).add("layout-params", HumanReadables.replaceHashCodes(view.getLayoutParams())).add("tag", view.getTag());
        if (view.getRootView() != null) {
            toStringHelper.add("root-is-layout-requested", view.getRootView().isLayoutRequested());
        }
        boolean bl = view.onCreateInputConnection(editorInfo = new EditorInfo()) != null;
        toStringHelper.add("has-input-connection", bl);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            StringBuilderPrinter stringBuilderPrinter = new StringBuilderPrinter(stringBuilder);
            editorInfo.dump((Printer)stringBuilderPrinter, "");
            stringBuilder.append("]");
            toStringHelper.add("editor-info", stringBuilder.toString().replace("\n", " "));
        }
        if (Build.VERSION.SDK_INT > 10) {
            toStringHelper.add("x", view.getX()).add("y", view.getY());
        }
        if (view instanceof TextView) {
            HumanReadables.innerDescribe((TextView)view, toStringHelper);
        }
        if (view instanceof Checkable) {
            HumanReadables.innerDescribe((Checkable)view, toStringHelper);
        }
        if (view instanceof ViewGroup) {
            HumanReadables.innerDescribe((ViewGroup)view, toStringHelper);
        }
        return toStringHelper.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getViewHierarchyErrorMessage(View rootView, List<View> problemViews, String errorHeader, String problemViewSuffix) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HumanReadables.getViewHierarchyErrorMessage(rootView, (List<View>)var1_1, (String)var2_2, (String)var3_3, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String getViewHierarchyErrorMessage(View rootView, List<View> problemViews, String errorHeader, String problemViewSuffix, int maxMsgLen) {
        void var4_4;
        void var1_1;
        Object object;
        Object[] objectArray;
        Object object2;
        void var3_3;
        boolean bl = problemViews == null || var3_3 != null;
        Preconditions.checkArgument(bl);
        StringBuilder stringBuilder = new StringBuilder((String)object2);
        if (var3_3 != null) {
            object2 = Locale.ROOT;
            objectArray = new Object[]{var3_3};
            stringBuilder.append(String.format((Locale)object2, "\nProblem views are marked with '%s' below.", objectArray));
        }
        object2 = Joiner.on("\n|\n");
        object = TreeIterables.depthFirstViewTraversalWithDistance((View)object);
        objectArray = new Function<TreeIterables.ViewAndDistance, String>(){
            final /* synthetic */ List val$problemViews;
            final /* synthetic */ String val$problemViewSuffix;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            public String apply(TreeIterables.ViewAndDistance viewAndDistance) {
                Object object;
                Object object2;
                void var1_1;
                Object object3 = "+%s%s ";
                if (object2.val$problemViews != null) {
                    if (object2.val$problemViews.contains(var1_1.getView())) {
                        object2 = object2.val$problemViewSuffix;
                        object = new StringBuilder();
                        object2 = ((StringBuilder)object).append((String)object3).append((String)object2).toString();
                    } else {
                        object2 = object3;
                    }
                } else {
                    object2 = object3;
                }
                object3 = Locale.ROOT;
                object = new Object[]{Strings.padStart(">", var1_1.getDistanceFromRoot() + 1, '-'), HumanReadables.describe(var1_1.getView())};
                return String.format((Locale)object3, (String)object2, (Object[])object);
            }
            {
                this.val$problemViews = list;
                this.val$problemViewSuffix = string;
            }
        };
        object = Iterables.transform(object, objectArray);
        object = ((Joiner)object2).join((Iterable)object);
        stringBuilder.append("\n\nView Hierarchy:\n").append((String)object);
        if (var4_4 < Integer.MAX_VALUE) {
            object = " [truncated]";
            if (stringBuilder.length() + ((String)object).length() <= var4_4) return stringBuilder.toString();
            stringBuilder.delete(Math.max(0, (int)(var4_4 - ((String)object).length())), stringBuilder.length());
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    private static String replaceHashCodes(Object instance) {
        Object object;
        if (instance == null) {
            return null;
        }
        Matcher matcher = OBJECT_HASH_CODE_PATTERN.matcher((CharSequence)(object = object.toString()));
        if (matcher.find()) {
            int n = matcher.start(2);
            String string = ((String)object).substring(0, n);
            int n2 = matcher.end(2);
            object = ((String)object).substring(n2);
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append(string).append("YYYYYY").append((String)object).toString();
        }
        return object;
    }

    private HumanReadables() {
    }

    private static void innerDescribe(ViewGroup viewGroup, MoreObjects.ToStringHelper helper) {
        ViewGroup viewGroup2;
        helper.add("child-count", viewGroup2.getChildCount());
    }

    private static void innerDescribe(Checkable checkable, MoreObjects.ToStringHelper helper) {
        Checkable checkable2;
        helper.add("is-checked", checkable2.isChecked());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void innerDescribe(TextView textBox, MoreObjects.ToStringHelper helper) {
        TextView textView;
        void var1_2;
        if (textBox.getText() != null) {
            var1_2.add("text", textView.getText());
        }
        if (textView.getError() != null) {
            var1_2.add("error-text", textView.getError());
        }
        if (textView.getHint() != null) {
            var1_2.add("hint", textView.getHint());
        }
        var1_2.add("input-type", textView.getInputType());
        var1_2.add("ime-target", textView.isInputMethodTarget());
        boolean bl = textView.getUrls().length > 0;
        var1_2.add("has-links", bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isViewIdGenerated(int id) {
        int n;
        if ((id & 0xFF000000) != 0) return 0 != 0;
        if ((n & 0xFFFFFF) == 0) return 0 != 0;
        return 1 != 0;
    }
}

