/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.view.View;
import android.view.ViewGroup;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.AbstractIterator;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.Maps;
import androidx.test.espresso.util.TreeIterables$TraversalStrategy-IA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class TreeIterables {
    private static final TreeViewer<View> VIEW_TREE_VIEWER;

    /*
     * WARNING - void declaration
     */
    static <T> Iterable<T> breadthFirstTraversal(T root, TreeViewer<T> viewer) {
        T t;
        void var1_1;
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(var1_1);
        TreeTraversalIterable treeTraversalIterable = new TreeTraversalIterable(t, TraversalStrategy.BREADTH_FIRST, (TreeViewer)var1_1);
        return treeTraversalIterable;
    }

    public static Iterable<View> breadthFirstViewTraversal(View root) {
        return TreeIterables.breadthFirstTraversal(root, VIEW_TREE_VIEWER);
    }

    /*
     * WARNING - void declaration
     */
    static <T> Iterable<T> depthFirstTraversal(T root, TreeViewer<T> viewer) {
        T t;
        void var1_1;
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(var1_1);
        TreeTraversalIterable treeTraversalIterable = new TreeTraversalIterable(t, TraversalStrategy.DEPTH_FIRST, (TreeViewer)var1_1);
        return treeTraversalIterable;
    }

    public static Iterable<View> depthFirstViewTraversal(View root) {
        return TreeIterables.depthFirstTraversal(root, VIEW_TREE_VIEWER);
    }

    public static Iterable<ViewAndDistance> depthFirstViewTraversalWithDistance(View root) {
        Object object;
        final DistanceRecordingTreeViewer<View> distanceRecordingTreeViewer = new DistanceRecordingTreeViewer<View>((View)object, VIEW_TREE_VIEWER);
        object = TreeIterables.depthFirstTraversal(object, distanceRecordingTreeViewer);
        Function<View, ViewAndDistance> function = new Function<View, ViewAndDistance>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public ViewAndDistance apply(View view) {
                void var1_1;
                ViewAndDistance viewAndDistance = new ViewAndDistance((View)var1_1, distanceRecordingTreeViewer.getDistance(var1_1));
                return viewAndDistance;
            }
        };
        return Iterables.transform(object, function);
    }

    static {
        ViewTreeViewer viewTreeViewer;
        VIEW_TREE_VIEWER = viewTreeViewer = new ViewTreeViewer();
    }

    private TreeIterables() {
    }

    static class DistanceRecordingTreeViewer<T>
    implements TreeViewer<T> {
        private final T root;
        private final Map<T, Integer> nodeToDistance = Maps.newHashMap();
        private final TreeViewer<T> delegateViewer;

        /*
         * WARNING - void declaration
         */
        int getDistance(T node) {
            void var1_1;
            return (Integer)Preconditions.checkNotNull(this.nodeToDistance.get(var1_1), "Never seen %s before", var1_1);
        }

        @Override
        public Collection<T> children(T node) {
            Collection<void> collection;
            if (node == this.root) {
                this.nodeToDistance.put(collection, 0);
            }
            int n = this.getDistance(collection) + 1;
            collection = this.delegateViewer.children((void)collection);
            for (void var4_4 : collection) {
                this.nodeToDistance.put(var4_4, n);
            }
            return collection;
        }

        /*
         * WARNING - void declaration
         */
        DistanceRecordingTreeViewer(T root, TreeViewer<T> delegateViewer) {
            void var2_2;
            void var1_1;
            this.root = Preconditions.checkNotNull(var1_1);
            this.delegateViewer = (TreeViewer)Preconditions.checkNotNull(var2_2);
        }
    }

    static interface TreeViewer<T> {
        public Collection<T> children(T var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class TreeTraversalIterable<T>
    implements Iterable<T> {
        private final T root;
        private final TraversalStrategy traversalStrategy;
        private final TreeViewer<T> treeViewer;

        @Override
        public Iterator<T> iterator() {
            LinkedList linkedList = Lists.newLinkedList();
            linkedList.add(this.root);
            AbstractIterator abstractIterator = new AbstractIterator<T>(this, linkedList){
                final /* synthetic */ LinkedList val$nodes;
                final /* synthetic */ TreeTraversalIterable this$0;

                @Override
                public T computeNext() {
                    if (this.val$nodes.isEmpty()) {
                        return this.endOfData();
                    }
                    Object object = Preconditions.checkNotNull(this.this$0.traversalStrategy.next(this.val$nodes), "Null items not allowed!");
                    this.this$0.traversalStrategy.combineNewChildren(this.val$nodes, this.this$0.treeViewer.children(object));
                    return object;
                }
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$nodes = linkedList;
                }
            };
            return abstractIterator;
        }

        /*
         * WARNING - void declaration
         */
        private TreeTraversalIterable(T root, TraversalStrategy traversalStrategy, TreeViewer<T> treeViewer) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.root = Preconditions.checkNotNull(var1_1);
            this.traversalStrategy = (TraversalStrategy)((Object)Preconditions.checkNotNull(var2_2));
            this.treeViewer = (TreeViewer)Preconditions.checkNotNull(var3_3);
        }
    }

    private static abstract class TraversalStrategy
    extends Enum<TraversalStrategy> {
        public static final /* enum */ TraversalStrategy BREADTH_FIRST;
        public static final /* enum */ TraversalStrategy DEPTH_FIRST;
        private static final /* synthetic */ TraversalStrategy[] $VALUES;

        public static TraversalStrategy valueOf(String name) {
            String string;
            return Enum.valueOf(TraversalStrategy.class, string);
        }

        <T> T next(LinkedList<T> nodes) {
            return nodes.removeFirst();
        }

        static {
            TraversalStrategy traversalStrategy = new TraversalStrategy("BREADTH_FIRST", 0){

                /*
                 * WARNING - void declaration
                 */
                @Override
                <T> void combineNewChildren(LinkedList<T> nodes, Collection<T> newChildren) {
                    void var2_2;
                    nodes.addAll((Collection<T>)var2_2);
                }
            };
            BREADTH_FIRST = traversalStrategy;
            traversalStrategy = new TraversalStrategy("DEPTH_FIRST", 1){

                /*
                 * WARNING - void declaration
                 */
                @Override
                <T> void combineNewChildren(LinkedList<T> nodes, Collection<T> newChildren) {
                    void var2_2;
                    nodes.addAll(0, (Collection<T>)var2_2);
                }
            };
            DEPTH_FIRST = traversalStrategy;
            $VALUES = traversalStrategyArray = new TraversalStrategy[]{TraversalStrategy.BREADTH_FIRST, TraversalStrategy.DEPTH_FIRST};
        }

        private TraversalStrategy() {
        }

        /* synthetic */ TraversalStrategy(String string, int n, TreeIterables$TraversalStrategy-IA traversalStrategy-IA) {
            this();
        }

        abstract <T> void combineNewChildren(LinkedList<T> var1, Collection<T> var2);

        public static TraversalStrategy[] values() {
            return (TraversalStrategy[])$VALUES.clone();
        }
    }

    static class ViewTreeViewer
    implements TreeViewer<View> {
        @Override
        public Collection<View> children(View view) {
            ViewGroup viewGroup;
            Preconditions.checkNotNull(view);
            if (viewGroup instanceof ViewGroup) {
                viewGroup = viewGroup;
                int n = viewGroup.getChildCount();
                ArrayList arrayList = Lists.newArrayList();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(viewGroup.getChildAt(i));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        ViewTreeViewer() {
        }
    }

    public static class ViewAndDistance {
        private final View view;
        private final int distanceFromRoot;

        public int getDistanceFromRoot() {
            return this.distanceFromRoot;
        }

        public View getView() {
            return this.view;
        }

        /*
         * WARNING - void declaration
         */
        private ViewAndDistance(View view, int distanceFromRoot) {
            void var2_2;
            void var1_1;
            this.view = var1_1;
            this.distanceFromRoot = var2_2;
        }
    }
}

