/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.Looper;
import android.util.Log;
import androidx.test.espresso.IdlingResource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class IdlingRegistry {
    private static final String TAG = IdlingRegistry.class.getSimpleName();
    private static final IdlingRegistry instance = new IdlingRegistry();
    private final Set<IdlingResource> resources = Collections.synchronizedSet(new HashSet());
    private final Set<Looper> loopers = Collections.synchronizedSet(new HashSet());

    public static IdlingRegistry getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Looper> getLoopers() {
        HashSet<Looper> result = new HashSet();
        Set<Looper> set = this.loopers;
        synchronized (set) {
            result = new HashSet<Looper>(this.loopers);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IdlingResource> getResources() {
        HashSet<IdlingResource> result = new HashSet();
        Set<IdlingResource> set = this.resources;
        synchronized (set) {
            result = new HashSet<IdlingResource>(this.resources);
        }
        return result;
    }

    IdlingRegistry() {
    }

    public void registerLooperAsIdlingResource(Looper looper) {
        if (null == looper) {
            throw new NullPointerException("looper cannot be null!");
        }
        if (Looper.getMainLooper() == looper) {
            throw new IllegalArgumentException("Not intended for use with main looper!");
        }
        this.loopers.add(looper);
    }

    public boolean register(IdlingResource ... idlingResources) {
        if (null == idlingResources) {
            throw new NullPointerException("idlingResources cannot be null!");
        }
        String string = Arrays.toString(idlingResources);
        Log.d((String)TAG, (String)("Registering idling resources: " + string));
        return this.resources.addAll(Arrays.asList(idlingResources));
    }

    public boolean unregister(IdlingResource ... idlingResources) {
        if (null == idlingResources) {
            throw new NullPointerException("idlingResources cannot be null!");
        }
        String string = Arrays.toString(idlingResources);
        Log.d((String)TAG, (String)("Unregistering idling resources: " + string));
        return this.resources.removeAll(Arrays.asList(idlingResources));
    }

    public boolean unregisterLooperAsIdlingResource(Looper looper) {
        if (null == looper) {
            throw new NullPointerException("looper cannot be null!");
        }
        return this.loopers.remove(looper);
    }
}

