/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.app.Instrumentation;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.runner.coverage.InstrumentationCoverageReporter;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import androidx.test.internal.runner.storage.RunnerFileIO;
import androidx.test.internal.runner.storage.RunnerIO;
import java.io.PrintStream;
import org.junit.runner.Result;

public class CoverageListener
extends InstrumentationRunListener {
    private final String coverageFilePath;
    private RunnerIO runnerIO;
    private InstrumentationCoverageReporter coverageReporter;
    private static final String REPORT_KEY_COVERAGE_PATH = "coverageFilePath";

    public CoverageListener(@Nullable String customCoverageFilePath) {
        this(customCoverageFilePath, new RunnerFileIO());
    }

    public CoverageListener(@Nullable String customCoverageFilePath, RunnerIO runnerIO) {
        this.coverageFilePath = customCoverageFilePath;
        this.runnerIO = runnerIO;
    }

    @VisibleForTesting
    CoverageListener(@Nullable String customCoverageFilePath, InstrumentationCoverageReporter coverageReporter) {
        this.coverageFilePath = customCoverageFilePath;
        this.coverageReporter = coverageReporter;
    }

    @Override
    public void setInstrumentation(Instrumentation instr) {
        super.setInstrumentation(instr);
        this.coverageReporter = new InstrumentationCoverageReporter(this.getInstrumentation(), this.runnerIO);
    }

    @Override
    public void instrumentationRunFinished(PrintStream writer, Bundle results, Result junitResults) {
        String actualCoveragePath = this.coverageReporter.generateCoverageReport(this.coverageFilePath, writer);
        results.putString(REPORT_KEY_COVERAGE_PATH, actualCoveragePath);
    }
}

