/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.junit;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.test.orchestrator.junit.ParcelableDescription;
import androidx.test.services.events.internal.StackTrimmer;
import org.junit.runner.notification.Failure;

public final class ParcelableFailure
implements Parcelable {
    private static final String TAG = "ParcelableFailure";
    private static final int MAX_STREAM_LENGTH = 16384;
    private final ParcelableDescription description;
    private final String trace;
    public static final Parcelable.Creator<ParcelableFailure> CREATOR = new Parcelable.Creator<ParcelableFailure>(){

        public ParcelableFailure createFromParcel(Parcel in) {
            return new ParcelableFailure(in);
        }

        public ParcelableFailure[] newArray(int size) {
            return new ParcelableFailure[size];
        }
    };

    public ParcelableFailure(Failure failure) {
        this.description = new ParcelableDescription(failure.getDescription());
        this.trace = StackTrimmer.getTrimmedStackTrace(failure);
    }

    private ParcelableFailure(Parcel in) {
        this.description = (ParcelableDescription)in.readParcelable(ParcelableDescription.class.getClassLoader());
        this.trace = in.readString();
    }

    public ParcelableFailure(ParcelableDescription description, Throwable t) {
        this(description, t.getMessage());
    }

    public ParcelableFailure(ParcelableDescription description, String message) {
        this.description = description;
        this.trace = ParcelableFailure.trimToLength(message);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.description, 0);
        out.writeString(this.trace);
    }

    private static String trimToLength(String trace) {
        if (!trace.endsWith("\n")) {
            trace = String.valueOf(trace).concat("\n");
        }
        if (trace.length() > 16384) {
            Log.i((String)TAG, (String)String.format("Stack trace too long, trimmed to first %s characters.", 16383));
            return String.valueOf(trace.substring(0, 16383)).concat("\n");
        }
        return trace;
    }

    public String getTrace() {
        return this.trace;
    }

    public ParcelableDescription getDescription() {
        return this.description;
    }
}

