/*
 * Decompiled with CFR 0.152.
 */
package appscanstdrdintegration.appscanstandard;

import appscanstdrdintegration.appscanstandard.AppScanStandardCommand;
import appscanstdrdintegration.appscanstandard.AppScanStandardInstallation;
import appscanstdrintegration.appscanstandard.utilities.AppScanStandardExecutor;
import appscanstdrintegration.appscanstandard.utilities.AppScanStandardManualExploreFile;
import appscanstdrintegration.appscanstandard.utilities.AppScanStandardScanTemplateBuilder;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AppScanStandardBuilder
extends Builder
implements SimpleBuildStep {
    private String startingURL;
    private boolean authScan;
    private boolean authScanRadio;
    private String authScanUser;
    private String authScanPw;
    private boolean generateReport;
    private String reportName;
    private boolean htmlReport;
    private boolean pdfReport;
    private String additionalCommands;
    private String policyFile;
    private String pathRecordedLoginSequence;
    private String installation;
    private String includeURLS;
    private PrintStream logger;
    private ArrayList<String> cmd;
    private ArrayList<String> cmdreport;
    String splitGlobalCommands;
    private boolean verbose;

    @DataBoundConstructor
    public AppScanStandardBuilder(String startingURL, String installation) {
        this.startingURL = startingURL;
        this.installation = installation;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String exe;
        String[] splitCommands;
        if (StringUtils.isBlank((String)this.getStartingURL())) {
            throw new AbortException("The AppScan Standard requires a Starting URL to run a scan.");
        }
        if (StringUtils.isBlank((String)this.getInstallation())) {
            throw new AbortException("AppScan Standard installation is not set, please configure it in the Configure Global Tools section.");
        }
        Node node = null;
        EnvVars envVars = build.getEnvironment(listener);
        this.logger = listener.getLogger();
        this.cmd = new ArrayList();
        this.cmdreport = new ArrayList();
        AppScanStandardScanTemplateBuilder scanTemplateBuilder = null;
        AppScanStandardManualExploreFile manualExploreFile = null;
        String baseScanName = "AppScanCMD_";
        this.cmd.add("/exec");
        this.cmd.add("/starting_url");
        this.cmd.add(this.getStartingURL());
        if (this.verbose) {
            this.cmd.add("/verbose");
        }
        if (this.isHtmlReport() && this.isPdfReport()) {
            baseScanName = baseScanName + new SimpleDateFormat("DD_MM_YY_HH_mm_ss").format(Calendar.getInstance().getTime());
            baseScanName = baseScanName + ".scan";
            this.cmd.add("/dest_scan");
            this.cmd.add(workspace.getRemote() + "\\" + baseScanName);
        }
        if (this.authScan) {
            if (this.authScanRadio && StringUtils.isNotBlank((String)this.pathRecordedLoginSequence)) {
                this.cmd.add("/login_file");
                this.cmd.add(this.pathRecordedLoginSequence);
            } else if (!this.authScanRadio && StringUtils.isNotBlank((String)this.authScanUser)) {
                scanTemplateBuilder = new AppScanStandardScanTemplateBuilder(this.authScanUser, this.authScanPw);
                scanTemplateBuilder.createScanTemplate(workspace);
                this.cmd.add("/scan_template");
                this.cmd.add(scanTemplateBuilder.getScanTemplateFileLocation());
            }
        }
        if (this.policyFile != null && !this.policyFile.isEmpty()) {
            this.cmd.add("/policy_file");
            this.cmd.add(this.policyFile);
        }
        if (this.isGenerateReport() && StringUtils.isNotBlank((String)this.getReportName())) {
            this.cmd.add("/report_file");
            this.cmd.add(workspace.getRemote() + "\\" + this.getReportName());
            this.cmd.add("/report_type");
            if (this.isHtmlReport()) {
                this.cmd.add("Html");
                if (this.isPdfReport()) {
                    this.cmdreport.add("/report");
                    this.cmdreport.add("/base_scan");
                    this.cmdreport.add(workspace.getRemote() + "\\" + baseScanName);
                    this.cmdreport.add("/report_file");
                    this.cmdreport.add(workspace.getRemote() + "\\" + this.getReportName());
                    this.cmdreport.add("/report_type");
                    this.cmdreport.add("Pdf");
                }
            } else if (this.isPdfReport()) {
                this.cmd.add("Pdf");
            } else {
                this.setHtmlReport(true);
                this.cmd.add("Html");
            }
        }
        if (this.includeURLS != null && !"".equals(this.includeURLS.trim())) {
            manualExploreFile = new AppScanStandardManualExploreFile(this.includeURLS, this.logger);
            manualExploreFile.createManualExploreFile(workspace);
            this.cmd.add("/merge_manual_explore_requests");
            this.cmd.add("/manual_explore_file");
            this.cmd.add(manualExploreFile.getManualExploreFileLocation());
        }
        for (String str : splitCommands = this.additionalCommands.split(" ")) {
            this.cmd.add(str);
        }
        this.splitGlobalCommands = this.getDescriptor().getAdditionalCommandsGlobal();
        if (!StringUtils.isBlank((String)this.splitGlobalCommands)) {
            String[] splitGlobalCommands2;
            for (String str : splitGlobalCommands2 = this.splitGlobalCommands.split(" ")) {
                this.cmd.add(str);
            }
        }
        if ("AppScanCMD.exe".equals(exe = AppScanStandardInstallation.getExecutable(this.installation, AppScanStandardCommand.APPSCANSTANDARDCLI, node, listener, envVars))) {
            this.logger.println("\nWarning: The path to the AppScan Standard installation may not be set, please configure it in the Configure Global Tools section or setup PATH.\n");
        }
        this.logger.println("AppScan Standard is going to scan the target:  " + this.getStartingURL());
        AppScanStandardExecutor.execute(workspace, launcher, exe, listener, this.cmd, this.cmdreport);
        if (scanTemplateBuilder != null) {
            scanTemplateBuilder.deleteScanTemplateFile();
        }
        if (manualExploreFile != null) {
            manualExploreFile.deleteManualExploreFile();
        }
        this.logger.println("Report available at: " + workspace.getRemote() + "\\" + this.getReportName());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getStartingURL() {
        return this.startingURL;
    }

    public String getInstallation() {
        return this.installation;
    }

    public boolean isAuthScan() {
        return this.authScan;
    }

    public String getAuthScanUser() {
        return this.authScanUser;
    }

    public String getAuthScanPw() {
        return this.authScanPw;
    }

    public boolean isHtmlReport() {
        return this.htmlReport;
    }

    public boolean isPdfReport() {
        return this.pdfReport;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getPathRecordedLoginSequence() {
        return this.pathRecordedLoginSequence;
    }

    public String getPolicyFile() {
        return this.policyFile;
    }

    public String getAdditionalCommands() {
        return this.additionalCommands;
    }

    public boolean isAuthScanRadio() {
        return this.authScanRadio;
    }

    public String getIncludeURLS() {
        return this.includeURLS;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @DataBoundSetter
    public void setAuthScan(boolean authScan) {
        this.authScan = authScan;
    }

    @DataBoundSetter
    public void setAuthScanRadio(boolean authScanRadio) {
        this.authScanRadio = authScanRadio;
    }

    @DataBoundSetter
    public void setAuthScanUser(String authScanUser) {
        this.authScanUser = authScanUser;
    }

    @DataBoundSetter
    public void setAuthScanPw(String authScanPw) {
        this.authScanPw = authScanPw;
    }

    @DataBoundSetter
    private void setHtmlReport(boolean htmlReport) {
        this.htmlReport = htmlReport;
    }

    @DataBoundSetter
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @DataBoundSetter
    public void setGenerateReport(boolean generateReport) {
        this.generateReport = generateReport;
    }

    @DataBoundSetter
    public void setPdfReport(boolean pdfReport) {
        this.pdfReport = pdfReport;
    }

    @DataBoundSetter
    public void setPathRecordedLoginSequence(String pathRecordedLoginSequence) {
        this.pathRecordedLoginSequence = pathRecordedLoginSequence;
    }

    @DataBoundSetter
    public void setPolicyFile(String policyFile) {
        this.policyFile = policyFile;
    }

    @DataBoundSetter
    public void setAdditionalCommands(String additionalCommands) {
        this.additionalCommands = additionalCommands;
    }

    @DataBoundSetter
    public void setIncludeURLS(String includeURLS) {
        this.includeURLS = includeURLS;
    }

    @DataBoundSetter
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String additionalCommandsGlobal;

        public DescriptorImpl() {
            this.load();
        }

        public ListBoxModel doFillInstallationItems() {
            ListBoxModel model = new ListBoxModel();
            for (AppScanStandardInstallation tool : AppScanStandardInstallation.allInstallations()) {
                model.add(Util.fixEmptyAndTrim((String)tool.getName()));
            }
            return model;
        }

        public FormValidation doCheckStartingURL(@QueryParameter String value) throws ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the starting URL");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the URL too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.additionalCommandsGlobal = formData.getString("additionalCommandsGlobal");
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return "Run AppScan Standard";
        }

        public String getAdditionalCommandsGlobal() {
            return this.additionalCommandsGlobal;
        }
    }
}

