/*
 * Decompiled with CFR 0.152.
 */
package appscanstdrdintegration.appscanstandard;

import appscanstdrintegration.appscanstandard.utilities.JenkinsExecutor;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.util.Log;

public class AppScanStandardInvocation {
    private String exe;
    private List<String> scriptFile;
    private final Map<String, String> environment = new HashMap<String, String>();

    public AppScanStandardInvocation(String exe) throws IOException, InterruptedException {
        this.exe = exe;
    }

    public boolean execute(JenkinsExecutor runner) {
        try {
            return runner.execute(this.buildCommandLine(), this.environment);
        }
        catch (IOException | InterruptedException e) {
            Log.error((Object)("Exception building command line." + e));
            return false;
        }
    }

    protected ArgumentListBuilder appendExecutable(ArgumentListBuilder args) {
        args.add(this.exe);
        return args;
    }

    public AppScanStandardInvocation addScriptFile(List<String> cliScriptContentReport) {
        this.scriptFile = cliScriptContentReport;
        return this;
    }

    protected ArgumentListBuilder appendScript(ArgumentListBuilder args) {
        for (String str : this.scriptFile) {
            args.add(str);
        }
        return args;
    }

    protected ArgumentListBuilder buildCommandLine() throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        this.appendExecutable(args);
        this.appendScript(args);
        return args;
    }
}

