/*
 * Decompiled with CFR 0.152.
 */
package appscanstdrintegration.appscanstandard.utilities;

import hudson.FilePath;
import java.io.IOException;
import org.jfree.util.Log;

public class AppScanStandardScanTemplateBuilder {
    private final String user;
    private final String password;
    private FilePath tempFile;

    public AppScanStandardScanTemplateBuilder(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void createScanTemplate(FilePath ws) {
        String scanTemplateContent = "<ScanConfiguration Version=\"9.0\"> <UserInput><FormFiller Version=\"2.0\" Enabled=\"True\" DefaultValue=\"1234\" UseDefaultValue=\"True\"> <Group LogicalName=\"InternalAppScanUserName\" MatchType=\"Partial\" Action=\"\"><Name>InternalAppScanUserName</Name><Value>" + this.user + "</Value><MatchNames>\t  <MatchName>user</MatchName>\t  <MatchName>name</MatchName>\t  <MatchName>id</MatchName>\t  <MatchName>login</MatchName>\t  <MatchName>logon</MatchName>\t  <MatchName>signin</MatchName>\t  <MatchName>signon</MatchName>\t  <MatchName>usr</MatchName>\t  <MatchName>member</MatchName>\t</MatchNames></Group><Group LogicalName=\"InternalAppScanPassword\" MatchType=\"Partial\" Action=\"\">\t<Name>InternalAppScanPassword</Name>\t<Value Encrypt=\"false\">" + this.password + "</Value>\t<MatchNames>\t  <MatchName>pass</MatchName>\t  <MatchName>word</MatchName>\t  <MatchName>pswd</MatchName>\t  <MatchName>pwd</MatchName>\t  <MatchName>auth</MatchName>\t</MatchNames>  </Group>\t</FormFiller></UserInput><SessionManagement Version=\"1.2\"><SessionManagementMode>Automatic</SessionManagementMode><SessionVerifier>  <Enable>True</Enable>  <OutSession>False</OutSession>  <Pattern /> <PatternType>RegularExpression</PatternType></SessionVerifier></SessionManagement></ScanConfiguration>";
        try {
            this.tempFile = ws.createTextTempFile("scan_template_login", ".scant", scanTemplateContent);
        }
        catch (IOException | IllegalStateException | InterruptedException e) {
            Log.error((Object)("Exception creating temporary scan template for authenticated scan." + e));
        }
    }

    public FilePath getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(FilePath tempFile) {
        this.tempFile = tempFile;
    }

    public String getScanTemplateFileLocation() {
        return this.tempFile.getRemote();
    }

    public void deleteScanTemplateFile() throws InterruptedException {
        try {
            this.tempFile.delete();
        }
        catch (IOException e) {
            Log.error((Object)("Exception deleting temporary scan template for authenticated scan." + e));
        }
    }
}

