/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJCrosstabColumn;
import ar.com.fdvs.dj.domain.DJCrosstabRow;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.ImageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.util.MultiPropertyComparator;
import ar.com.fdvs.dj.util.SortInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SortUtils {
    public static <T> List<T> sortCollection(Collection<T> dummyCollection, List columns) {
        ArrayList<T> l = new ArrayList<T>(dummyCollection);
        ArrayList<SortInfo> info = new ArrayList<SortInfo>();
        for (Object object : columns) {
            if (object instanceof String) {
                info.add(new SortInfo((String)object, true));
                continue;
            }
            if (object instanceof ExpressionColumn || object instanceof ImageColumn || !(object instanceof PropertyColumn)) continue;
            info.add(new SortInfo(((PropertyColumn)object).getColumnProperty().getProperty(), true));
        }
        MultiPropertyComparator mpc = new MultiPropertyComparator(info);
        Collections.sort(l, mpc);
        return l;
    }

    public static <T> List<T> sortCollection(Collection<T> dummyCollection, String[] properties) {
        ArrayList<T> l = new ArrayList<T>(dummyCollection);
        ArrayList<SortInfo> info = new ArrayList<SortInfo>();
        for (String property : properties) {
            info.add(new SortInfo(property, true));
        }
        MultiPropertyComparator mpc = new MultiPropertyComparator(info);
        Collections.sort(l, mpc);
        return l;
    }

    public static <T> List<T> sortCollection(Collection<T> dummyCollection, DJCrosstab crosstab) {
        ArrayList<T> l = new ArrayList<T>(dummyCollection);
        ArrayList<SortInfo> info = new ArrayList<SortInfo>();
        for (DJCrosstabRow row : crosstab.getRows()) {
            info.add(new SortInfo(row.getProperty().getProperty(), true));
        }
        for (DJCrosstabColumn col : crosstab.getColumns()) {
            info.add(new SortInfo(col.getProperty().getProperty(), true));
        }
        MultiPropertyComparator mpc = new MultiPropertyComparator(info);
        Collections.sort(l, mpc);
        return l;
    }
}

