/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.Pact;
import au.com.dius.pact.consumer.PactError;
import au.com.dius.pact.consumer.PactMismatch;
import au.com.dius.pact.consumer.PactMismatchException;
import au.com.dius.pact.consumer.PactVerification;
import au.com.dius.pact.consumer.PactVerified$;
import au.com.dius.pact.consumer.TestRun;
import au.com.dius.pact.consumer.UserCodeFailed;
import au.com.dius.pact.consumer.VerificationResult;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.model.MockProviderConfig;
import au.com.dius.pact.model.PactConfig;
import au.com.dius.pact.model.PactFragment;
import au.com.dius.pact.model.PactSpecVersion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactProviderRule
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactProviderRule.class);
    public static VerificationResult PACT_VERIFIED = PactVerified$.MODULE$;
    private Map<String, PactFragment> fragments;
    private final String provider;
    private Object target;
    private final MockProviderConfig config;

    public PactProviderRule(String provider, String host, Integer port, PactConfig pactConfig, Object target) {
        this.provider = provider;
        this.target = target;
        this.config = host == null && port == null ? MockProviderConfig.createDefault((PactConfig)pactConfig) : new MockProviderConfig(port.intValue(), host, pactConfig);
    }

    public PactProviderRule(String provider, String host, Integer port, Object target) {
        this(provider, host, port, PactConfig.apply((PactSpecVersion)PactSpecVersion.V2), target);
    }

    public PactProviderRule(String provider, Object target) {
        this(provider, null, null, PactConfig.apply((PactSpecVersion)PactSpecVersion.V2), target);
    }

    public PactProviderRule(String provider, PactSpecVersion pactSpecVersion, Object target) {
        this(provider, null, null, PactConfig.apply((PactSpecVersion)pactSpecVersion), target);
    }

    public MockProviderConfig getConfig() {
        return this.config;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PactVerification pactDef = (PactVerification)description.getAnnotation(PactVerification.class);
                if (pactDef == null) {
                    base.evaluate();
                    return;
                }
                Map<String, PactFragment> pacts = PactProviderRule.this.getPacts(pactDef.fragment());
                Optional<PactFragment> fragment = pactDef.value().length == 1 && StringUtils.isEmpty((CharSequence)pactDef.value()[0]) ? pacts.values().stream().findFirst() : Arrays.asList(pactDef.value()).stream().map(pacts::get).filter(p -> p != null).findFirst();
                if (!fragment.isPresent()) {
                    base.evaluate();
                    return;
                }
                VerificationResult result = fragment.get().runConsumer(PactProviderRule.this.config, new TestRun(){

                    public void run(MockProviderConfig config) throws Throwable {
                        base.evaluate();
                    }
                });
                if (!result.equals(PACT_VERIFIED)) {
                    if (result instanceof PactError) {
                        throw ((PactError)result).error();
                    }
                    if (result instanceof UserCodeFailed) {
                        throw (RuntimeException)((UserCodeFailed)result).error();
                    }
                    if (result instanceof PactMismatch && !pactDef.expectMismatch()) {
                        PactMismatch mismatch = (PactMismatch)result;
                        throw new PactMismatchException(mismatch);
                    }
                } else if (pactDef.expectMismatch()) {
                    throw new RuntimeException("Expected a pact mismatch (PactVerification.expectMismatch is set to true)");
                }
            }
        };
    }

    protected Map<String, PactFragment> getPacts(String fragment) {
        if (this.fragments == null) {
            this.fragments = new HashMap<String, PactFragment>();
            for (Method m : this.target.getClass().getMethods()) {
                Pact pact;
                if (!this.conformsToSignature(m) || !this.methodMatchesFragment(m, fragment) || !StringUtils.isEmpty((CharSequence)(pact = m.getAnnotation(Pact.class)).provider()) && !this.provider.equals(pact.provider())) continue;
                PactDslWithProvider dslBuilder = ConsumerPactBuilder.consumer((String)pact.consumer()).hasPactWith(this.provider);
                try {
                    this.fragments.put(this.provider, (PactFragment)m.invoke(this.target, dslBuilder));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to invoke pact method", (Throwable)e);
                    throw new RuntimeException("Failed to invoke pact method", e);
                }
            }
        }
        return this.fragments;
    }

    private boolean methodMatchesFragment(Method m, String fragment) {
        return StringUtils.isEmpty((CharSequence)fragment) || m.getName().equals(fragment);
    }

    private boolean conformsToSignature(Method m) {
        boolean conforms;
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = conforms = pact != null && PactFragment.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(PactDslWithProvider.class);
        if (!conforms && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public PactFragment xxx(PactDslWithProvider builder)'");
        }
        return conforms;
    }
}

