/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import java.util.HashMap;
import java.util.Map;

public abstract class DslPart {
    public static final String HEXADECIMAL = "[0-9a-fA-F]+";
    public static final String IP_ADDRESS = "(\\d{1,3}\\.)+\\d{1,3}";
    public static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    protected final DslPart parent;
    protected final String root;
    protected Map<String, Map<String, Object>> matchers = new HashMap<String, Map<String, Object>>();

    public DslPart(DslPart parent, String root) {
        this.parent = parent;
        this.root = root;
    }

    public DslPart(String root) {
        this.parent = null;
        this.root = root;
    }

    protected abstract void putObject(DslPart var1);

    protected abstract void putArray(DslPart var1);

    public abstract Object getBody();

    public abstract PactDslJsonArray array(String var1);

    public abstract PactDslJsonArray array();

    public abstract DslPart closeArray();

    @Deprecated
    public abstract PactDslJsonBody arrayLike(String var1);

    @Deprecated
    public abstract PactDslJsonBody arrayLike();

    public abstract PactDslJsonBody eachLike(String var1);

    public abstract PactDslJsonBody eachLike();

    public abstract PactDslJsonBody minArrayLike(String var1, Integer var2);

    public abstract PactDslJsonBody minArrayLike(Integer var1);

    public abstract PactDslJsonBody maxArrayLike(String var1, Integer var2);

    public abstract PactDslJsonBody maxArrayLike(Integer var1);

    public abstract PactDslJsonBody object(String var1);

    public abstract PactDslJsonBody object();

    public abstract DslPart closeObject();

    public Map<String, Map<String, Object>> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(Map<String, Map<String, Object>> matchers) {
        this.matchers = matchers;
    }

    protected Map<String, Object> matchType() {
        return this.matchType("type");
    }

    protected Map<String, Object> matchType(String type) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("match", type);
        return jsonObject;
    }

    protected Map<String, Object> regexp(String regex) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("regex", regex);
        return jsonObject;
    }

    protected Map<String, Object> matchTimestamp(String format) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("timestamp", format);
        return jsonObject;
    }

    protected Map<String, Object> matchDate(String format) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("date", format);
        return jsonObject;
    }

    protected Map<String, Object> matchTime(String format) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("time", format);
        return jsonObject;
    }

    protected Map<String, Object> matchMin(Integer min) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("min", min);
        jsonObject.put("match", "type");
        return jsonObject;
    }

    protected Map<String, Object> matchMax(Integer max) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("min", max);
        jsonObject.put("match", "type");
        return jsonObject;
    }

    public PactDslJsonBody asBody() {
        return (PactDslJsonBody)this;
    }

    public PactDslJsonArray asArray() {
        return (PactDslJsonArray)this;
    }
}

