/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.dsl.DateMatcher;
import au.com.dius.pact.consumer.dsl.EqualsMatcher;
import au.com.dius.pact.consumer.dsl.HexadecimalMatcher;
import au.com.dius.pact.consumer.dsl.IncludeMatcher;
import au.com.dius.pact.consumer.dsl.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.Matcher;
import au.com.dius.pact.consumer.dsl.NullMatcher;
import au.com.dius.pact.consumer.dsl.RegexpMatcher;
import au.com.dius.pact.consumer.dsl.TimeMatcher;
import au.com.dius.pact.consumer.dsl.TimestampMatcher;
import au.com.dius.pact.consumer.dsl.TypeMatcher;
import au.com.dius.pact.consumer.dsl.UuidMatcher;
import au.com.dius.pact.model.generators.Generator;
import au.com.dius.pact.model.generators.RandomBooleanGenerator;
import au.com.dius.pact.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.model.generators.RandomIntGenerator;
import au.com.dius.pact.model.generators.RandomStringGenerator;
import au.com.dius.pact.model.matchingrules.MatchingRule;
import au.com.dius.pact.model.matchingrules.NumberTypeMatcher;
import java.text.ParseException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J\u0014\u0010\u0013\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0007J\u0014\u0010\u0016\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J\u0014\u0010\u0017\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007J\u0019\u0010\u0019\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010\u001d\u001a\u00020\fH\u0007J\u0014\u0010\u001e\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0014H\u0007J\u001c\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J\u001c\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J\u0014\u0010\"\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J \u0010#\u001a\u00020\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J \u0010$\u001a\u00020\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J\u0014\u0010%\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0007J\u001a\u0010&\u001a\u00020'2\b\u0010\r\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006("}, d2={"Lau/com/dius/pact/consumer/dsl/Matchers;", "", "()V", "HEXADECIMAL", "Lkotlin/text/Regex;", "getHEXADECIMAL", "()Lkotlin/text/Regex;", "IP_ADDRESS", "getIP_ADDRESS", "UUID_REGEX", "getUUID_REGEX", "bool", "Lau/com/dius/pact/consumer/dsl/Matcher;", "value", "", "(Ljava/lang/Boolean;)Lau/com/dius/pact/consumer/dsl/Matcher;", "date", "pattern", "", "decimal", "", "equalTo", "hexValue", "identifier", "includesStr", "integer", "", "(Ljava/lang/Long;)Lau/com/dius/pact/consumer/dsl/Matcher;", "ipAddress", "nullValue", "numeric", "regexp", "re", "Ljava/util/regex/Pattern;", "string", "time", "timestamp", "uuid", "validateTimeValue", "", "pact-jvm-consumer_2.12"})
public final class Matchers {
    @NotNull
    private static final Regex HEXADECIMAL;
    @NotNull
    private static final Regex IP_ADDRESS;
    @NotNull
    private static final Regex UUID_REGEX;
    public static final Matchers INSTANCE;

    @NotNull
    public final Regex getHEXADECIMAL() {
        return HEXADECIMAL;
    }

    @NotNull
    public final Regex getIP_ADDRESS() {
        return IP_ADDRESS;
    }

    @NotNull
    public final Regex getUUID_REGEX() {
        return UUID_REGEX;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull Pattern re, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)re, (String)"re");
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = value;
            Pattern pattern = re;
            bl2 = false;
            pattern = new Regex(pattern);
            bl2 = false;
            if (!pattern.matches(charSequence)) {
                throw (Throwable)new InvalidMatcherException("Example \"" + value + "\" does not match regular expression \"" + re + '\"');
            }
        }
        String string = re.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"re.toString()");
        return new RegexpMatcher(string, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher regexp$default(Pattern pattern, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return Matchers.regexp(pattern, string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull Pattern re) {
        return Matchers.regexp$default(re, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull String regexp, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)regexp, (String)"regexp");
        Pattern pattern = Pattern.compile(regexp);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(regexp)");
        return Matchers.regexp(pattern, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher regexp$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return Matchers.regexp(string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull String regexp) {
        return Matchers.regexp$default(regexp, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher hexValue(@Nullable String value) {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = value;
            Regex regex = HEXADECIMAL;
            bl2 = false;
            if (!regex.matches(charSequence)) {
                throw (Throwable)new InvalidMatcherException("Example \"" + value + "\" is not a hexadecimal value");
            }
        }
        return new HexadecimalMatcher(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher hexValue$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Matchers.hexValue(string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher hexValue() {
        return Matchers.hexValue$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher identifier(@Nullable Object value) {
        Object object = value;
        if (object == null) {
            object = 12345678;
        }
        return new TypeMatcher(object, (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER), (Generator)(value == null ? new RandomIntGenerator(0, Integer.MAX_VALUE) : null));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher identifier$default(Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        return Matchers.identifier(object);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher identifier() {
        return Matchers.identifier$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher ipAddress(@Nullable String value) {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = value;
            Regex regex = IP_ADDRESS;
            bl2 = false;
            if (!regex.matches(charSequence)) {
                throw (Throwable)new InvalidMatcherException("Example \"" + value + "\" is not an ip adress");
            }
        }
        return new RegexpMatcher(IP_ADDRESS.toString(), "127.0.0.1");
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher ipAddress$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Matchers.ipAddress(string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher ipAddress() {
        return Matchers.ipAddress$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher numeric(@Nullable Number value) {
        Number number = value;
        if (number == null) {
            number = 100;
        }
        return new TypeMatcher(number, (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.NUMBER), (Generator)(value == null ? new RandomDecimalGenerator(6) : null));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher numeric$default(Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = null;
        }
        return Matchers.numeric(number);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher numeric() {
        return Matchers.numeric$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher decimal(@Nullable Number value) {
        Number number = value;
        if (number == null) {
            number = 100.0;
        }
        return new TypeMatcher(number, (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL), (Generator)(value == null ? new RandomDecimalGenerator(6) : null));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher decimal$default(Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = null;
        }
        return Matchers.decimal(number);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher decimal() {
        return Matchers.decimal$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher integer(@Nullable Long value) {
        Number number = value;
        if (number == null) {
            number = 100;
        }
        return new TypeMatcher(number, (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER), (Generator)(value == null ? new RandomIntGenerator(0, Integer.MAX_VALUE) : null));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher integer$default(Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        return Matchers.integer(l);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher integer() {
        return Matchers.integer$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher timestamp(@Nullable String pattern, @Nullable String value) {
        String pattern2;
        String string = pattern;
        if (string == null) {
            FastDateFormat fastDateFormat = DateFormatUtils.ISO_DATETIME_FORMAT;
            Intrinsics.checkExpressionValueIsNotNull((Object)fastDateFormat, (String)"DateFormatUtils.ISO_DATETIME_FORMAT");
            string = fastDateFormat.getPattern();
        }
        String string2 = pattern2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pattern");
        INSTANCE.validateTimeValue(value, string2);
        return new TimestampMatcher(pattern2, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher timestamp$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return Matchers.timestamp(string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher timestamp(@Nullable String pattern) {
        return Matchers.timestamp$default(pattern, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher timestamp() {
        return Matchers.timestamp$default(null, null, 3, null);
    }

    private final void validateTimeValue(String value, String pattern) {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                DateUtils.parseDateStrictly((String)value, (String[])new String[]{pattern});
            }
            catch (ParseException e) {
                throw (Throwable)new InvalidMatcherException("Example \"" + value + "\" does not match pattern \"" + pattern + '\"');
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher time(@Nullable String pattern, @Nullable String value) {
        String pattern2;
        String string = pattern;
        if (string == null) {
            FastDateFormat fastDateFormat = DateFormatUtils.ISO_TIME_FORMAT;
            Intrinsics.checkExpressionValueIsNotNull((Object)fastDateFormat, (String)"DateFormatUtils.ISO_TIME_FORMAT");
            string = fastDateFormat.getPattern();
        }
        String string2 = pattern2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pattern");
        INSTANCE.validateTimeValue(value, string2);
        return new TimeMatcher(pattern2, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher time$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return Matchers.time(string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher time(@Nullable String pattern) {
        return Matchers.time$default(pattern, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher time() {
        return Matchers.time$default(null, null, 3, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher date(@Nullable String pattern, @Nullable String value) {
        String pattern2;
        String string = pattern;
        if (string == null) {
            FastDateFormat fastDateFormat = DateFormatUtils.ISO_DATE_FORMAT;
            Intrinsics.checkExpressionValueIsNotNull((Object)fastDateFormat, (String)"DateFormatUtils.ISO_DATE_FORMAT");
            string = fastDateFormat.getPattern();
        }
        String string2 = pattern2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pattern");
        INSTANCE.validateTimeValue(value, string2);
        return new DateMatcher(pattern2, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher date$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return Matchers.date(string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher date(@Nullable String pattern) {
        return Matchers.date$default(pattern, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher date() {
        return Matchers.date$default(null, null, 3, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher uuid(@Nullable String value) {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = value;
            Regex regex = UUID_REGEX;
            bl2 = false;
            if (!regex.matches(charSequence)) {
                throw (Throwable)new InvalidMatcherException("Example \"" + value + "\" is not a UUID");
            }
        }
        return new UuidMatcher(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher uuid$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Matchers.uuid(string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher uuid() {
        return Matchers.uuid$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher string(@Nullable String value) {
        return value != null ? (Matcher)new TypeMatcher(value, (MatchingRule)au.com.dius.pact.model.matchingrules.TypeMatcher.INSTANCE, null) : (Matcher)new TypeMatcher("string", (MatchingRule)au.com.dius.pact.model.matchingrules.TypeMatcher.INSTANCE, (Generator)new RandomStringGenerator(10));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher string$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Matchers.string(string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher string() {
        return Matchers.string$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher bool(@Nullable Boolean value) {
        return value != null ? (Matcher)new TypeMatcher(value, (MatchingRule)au.com.dius.pact.model.matchingrules.TypeMatcher.INSTANCE, null) : (Matcher)new TypeMatcher(true, (MatchingRule)au.com.dius.pact.model.matchingrules.TypeMatcher.INSTANCE, (Generator)RandomBooleanGenerator.INSTANCE);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* synthetic */ Matcher bool$default(Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return Matchers.bool(bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher bool() {
        return Matchers.bool$default(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Matcher equalTo(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return new EqualsMatcher(value);
    }

    @JvmStatic
    @NotNull
    public static final Matcher includesStr(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return new IncludeMatcher(value);
    }

    @JvmStatic
    @NotNull
    public static final Matcher nullValue() {
        return NullMatcher.INSTANCE;
    }

    private Matchers() {
    }

    static {
        Matchers matchers;
        INSTANCE = matchers = new Matchers();
        HEXADECIMAL = new Regex("[0-9a-fA-F]+");
        IP_ADDRESS = new Regex("(\\d{1,3}\\.)+\\d{1,3}");
        UUID_REGEX = new Regex("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    }
}

