/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestBase;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.PactReaderKt;
import au.com.dius.pact.model.generators.Category;
import au.com.dius.pact.model.generators.Generator;
import au.com.dius.pact.model.generators.ProviderStateGenerator;
import au.com.dius.pact.model.matchingrules.MatchingRule;
import au.com.dius.pact.model.matchingrules.RegexMatcher;
import com.mifmif.common.regex.Generex;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.transform.TransformerException;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class PactDslRequestWithoutPath
extends PactDslRequestBase {
    private final ConsumerPactBuilder consumerPactBuilder;
    private PactDslWithState pactDslWithState;
    private String description;
    private String consumerName;
    private String providerName;
    private final PactDslResponse defaultResponseValues;

    public PactDslRequestWithoutPath(ConsumerPactBuilder consumerPactBuilder, PactDslWithState pactDslWithState, String description, PactDslRequestWithoutPath defaultRequestValues, PactDslResponse defaultResponseValues) {
        super(defaultRequestValues);
        this.consumerPactBuilder = consumerPactBuilder;
        this.pactDslWithState = pactDslWithState;
        this.description = description;
        this.consumerName = pactDslWithState.consumerName;
        this.providerName = pactDslWithState.providerName;
        this.defaultResponseValues = defaultResponseValues;
        this.setupDefaultValues();
    }

    public PactDslRequestWithoutPath method(String method) {
        this.requestMethod = method;
        return this;
    }

    public PactDslRequestWithoutPath headers(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.requestHeaders.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return this;
    }

    public PactDslRequestWithoutPath headers(String firstHeaderName, String firstHeaderValue, String ... headerNameValuePairs) {
        if (headerNameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Pair key value should be provided, but there is one key without value.");
        }
        this.requestHeaders.put(firstHeaderName, Collections.singletonList(firstHeaderValue));
        for (int i = 0; i < headerNameValuePairs.length; i += 2) {
            this.requestHeaders.put(headerNameValuePairs[i], Collections.singletonList(headerNameValuePairs[i + 1]));
        }
        return this;
    }

    public PactDslRequestWithoutPath query(String query) {
        this.query = PactReaderKt.queryStringToMap((String)query, (boolean)false);
        return this;
    }

    public PactDslRequestWithoutPath body(String body) {
        this.requestBody = OptionalBody.body((byte[])body.getBytes());
        return this;
    }

    public PactDslRequestWithoutPath body(String body, String mimeType) {
        this.requestBody = OptionalBody.body((byte[])body.getBytes());
        this.requestHeaders.put("Content-Type", Collections.singletonList(mimeType));
        return this;
    }

    public PactDslRequestWithoutPath body(String body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithoutPath body(Supplier<String> body) {
        this.requestBody = OptionalBody.body((byte[])body.get().getBytes());
        return this;
    }

    public PactDslRequestWithoutPath body(Supplier<String> body, String mimeType) {
        this.requestBody = OptionalBody.body((byte[])body.get().getBytes());
        this.requestHeaders.put("Content-Type", Collections.singletonList(mimeType));
        return this;
    }

    public PactDslRequestWithoutPath body(Supplier<String> body, ContentType mimeType) {
        return this.body(body, mimeType.toString());
    }

    public PactDslRequestWithoutPath bodyWithSingleQuotes(String body) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body);
    }

    public PactDslRequestWithoutPath bodyWithSingleQuotes(String body, String mimeType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, mimeType);
    }

    public PactDslRequestWithoutPath bodyWithSingleQuotes(String body, ContentType mimeType) {
        if (body != null) {
            body = QuoteUtil.convert(body);
        }
        return this.body(body, mimeType);
    }

    public PactDslRequestWithoutPath body(JSONObject body) {
        this.requestBody = OptionalBody.body((byte[])body.toString().getBytes());
        if (!this.requestHeaders.containsKey("Content-Type")) {
            this.requestHeaders.put("Content-Type", Collections.singletonList(ContentType.APPLICATION_JSON.toString()));
        }
        return this;
    }

    public PactDslRequestWithoutPath body(DslPart body) {
        DslPart parent = body.close();
        this.requestMatchers.addCategory(parent.matchers);
        this.requestGenerators.addGenerators(parent.generators);
        this.requestBody = OptionalBody.body((byte[])parent.toString().getBytes());
        if (!this.requestHeaders.containsKey("Content-Type")) {
            this.requestHeaders.put("Content-Type", Collections.singletonList(ContentType.APPLICATION_JSON.toString()));
        }
        return this;
    }

    public PactDslRequestWithoutPath body(Document body) throws TransformerException {
        this.requestBody = OptionalBody.body((byte[])ConsumerPactBuilder.xmlToString(body).getBytes());
        if (!this.requestHeaders.containsKey("Content-Type")) {
            this.requestHeaders.put("Content-Type", Collections.singletonList(ContentType.APPLICATION_XML.toString()));
        }
        return this;
    }

    public PactDslRequestWithPath path(String path) {
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.consumerName, this.providerName, this.pactDslWithState.state, this.description, path, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers, this.requestGenerators, this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslRequestWithPath matchPath(String pathRegex) {
        return this.matchPath(pathRegex, new Generex(pathRegex).random());
    }

    public PactDslRequestWithPath matchPath(String pathRegex, String path) {
        this.requestMatchers.addCategory("path").addRule((MatchingRule)new RegexMatcher(pathRegex));
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.consumerName, this.providerName, this.pactDslWithState.state, this.description, path, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers, this.requestGenerators, this.defaultRequestValues, this.defaultResponseValues);
    }

    public PactDslRequestWithoutPath withFileUpload(String partName, String fileName, String fileContentType, byte[] data) throws IOException {
        this.setupFileUpload(partName, fileName, fileContentType, data);
        return this;
    }

    public PactDslRequestWithoutPath headerFromProviderState(String name, String expression, String example) {
        this.requestGenerators.addGenerator(Category.HEADER, name, (Generator)new ProviderStateGenerator(expression));
        this.requestHeaders.put(name, Collections.singletonList(example));
        return this;
    }

    public PactDslRequestWithoutPath queryParameterFromProviderState(String name, String expression, String example) {
        this.requestGenerators.addGenerator(Category.QUERY, name, (Generator)new ProviderStateGenerator(expression));
        this.query.put(name, Collections.singletonList(example));
        return this;
    }

    public PactDslRequestWithPath pathFromProviderState(String expression, String example) {
        this.requestGenerators.addGenerator(Category.PATH, (Generator)new ProviderStateGenerator(expression));
        return new PactDslRequestWithPath(this.consumerPactBuilder, this.consumerName, this.providerName, this.pactDslWithState.state, this.description, example, this.requestMethod, this.requestHeaders, this.query, this.requestBody, this.requestMatchers, this.requestGenerators, this.defaultRequestValues, this.defaultResponseValues);
    }
}

