/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.matchers;

import au.com.dius.pact.core.support.Json;
import com.google.gson.JsonElement;
import difflib.Chunk;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"NEW_LINE", "", "generateDiff", "", "", "expectedBodyString", "actualBodyString", "generateJsonDiff", "expected", "Lcom/google/gson/JsonElement;", "actual", "pact-jvm-core-matchers"})
public final class DiffUtilsKt {
    private static final char NEW_LINE = '\n';

    @NotNull
    public static final List<String> generateDiff(@NotNull String expectedBodyString, @NotNull String actualBodyString) {
        Intrinsics.checkParameterIsNotNull((Object)expectedBodyString, (String)"expectedBodyString");
        Intrinsics.checkParameterIsNotNull((Object)actualBodyString, (String)"actualBodyString");
        List expectedLines = StringsKt.split$default((CharSequence)expectedBodyString, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        List actualLines = StringsKt.split$default((CharSequence)actualBodyString, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        Patch patch = DiffUtils.diff((List)expectedLines, (List)actualLines);
        boolean bl = false;
        List diff = new ArrayList();
        Patch patch2 = patch;
        Intrinsics.checkExpressionValueIsNotNull((Object)patch2, (String)"patch");
        List list = patch2.getDeltas();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"patch.deltas");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            Delta delta;
            block5: {
                block6: {
                    delta = (Delta)element$iv;
                    boolean bl2 = false;
                    Delta delta2 = delta;
                    Intrinsics.checkExpressionValueIsNotNull((Object)delta2, (String)"delta");
                    Chunk chunk = delta2.getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull((Object)chunk, (String)"delta.original");
                    if (chunk.getPosition() < 1) break block5;
                    if (diff.isEmpty()) break block6;
                    Chunk chunk2 = delta.getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull((Object)chunk2, (String)"delta.original");
                    if (!(Intrinsics.areEqual((Object)((String)expectedLines.get(chunk2.getPosition() - 1)), (Object)((String)CollectionsKt.last((List)diff))) ^ true)) break block5;
                }
                Chunk chunk = delta.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull((Object)chunk, (String)"delta.original");
                diff.add(expectedLines.get(chunk.getPosition() - 1));
            }
            Chunk chunk = delta.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)chunk, (String)"delta.original");
            List list2 = chunk.getLines();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"delta.original.lines");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (String)element$iv2;
                boolean bl3 = false;
                diff.add('-' + it);
            }
            Chunk chunk3 = delta.getRevised();
            Intrinsics.checkExpressionValueIsNotNull((Object)chunk3, (String)"delta.revised");
            List list3 = chunk3.getLines();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"delta.revised.lines");
            $this$forEach$iv2 = list3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (String)element$iv2;
                boolean bl4 = false;
                diff.add('+' + it);
            }
            Chunk chunk4 = delta.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)chunk4, (String)"delta.original");
            int n = chunk4.getPosition();
            Chunk chunk5 = delta.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)chunk5, (String)"delta.original");
            int pos = n + chunk5.getLines().size();
            if (pos >= expectedLines.size()) continue;
            diff.add(expectedLines.get(pos));
        }
        return diff;
    }

    @NotNull
    public static final String generateJsonDiff(@NotNull JsonElement expected, @NotNull JsonElement actual) {
        String expectedJson;
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
        String actualJson = Json.INSTANCE.getGsonPretty().toJson(actual);
        String string = expectedJson = Json.INSTANCE.getGsonPretty().toJson(expected);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expectedJson");
        String string2 = actualJson;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"actualJson");
        return CollectionsKt.joinToString$default((Iterable)DiffUtilsKt.generateDiff(string, string2), (CharSequence)String.valueOf('\n'), null, null, (int)0, null, null, (int)62, null);
    }
}

