/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.InvalidPactException;
import au.com.dius.pact.core.model.MergeResult;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactMerge;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.PactWriteMode;
import au.com.dius.pact.core.model.PactWriter;
import au.com.dius.pact.core.support.Json;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lau/com/dius/pact/core/model/DefaultPactWriter;", "Lau/com/dius/pact/core/model/PactWriter;", "Lmu/KLogging;", "()V", "pactWriteMode", "Lau/com/dius/pact/core/model/PactWriteMode;", "readFileUtf8", "", "file", "Ljava/io/RandomAccessFile;", "writePact", "", "pact", "Lau/com/dius/pact/core/model/Pact;", "writer", "Ljava/io/PrintWriter;", "pactSpecVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "pactFile", "Ljava/io/File;", "pact-jvm-core-model"})
public final class DefaultPactWriter
extends KLogging
implements PactWriter {
    public static final DefaultPactWriter INSTANCE;

    @Override
    public void writePact(@NotNull Pact<?> pact, @NotNull PrintWriter writer, @NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        pact.sortInteractions();
        Map<String, ?> jsonData = pact.toMap(pactSpecVersion);
        Json.INSTANCE.getGsonPretty().toJson(jsonData, (Appendable)writer);
    }

    @Override
    public void writePact(@NotNull Pact<?> pact, @NotNull PrintWriter writer) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.writePact(pact, writer, PactSpecVersion.V3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writePact(@NotNull File pactFile, @NotNull Pact<?> pact, @NotNull PactSpecVersion pactSpecVersion) {
        Intrinsics.checkParameterIsNotNull((Object)pactFile, (String)"pactFile");
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (this.pactWriteMode() == PactWriteMode.MERGE && pactFile.exists() && pactFile.length() > 0L) {
            RandomAccessFile raf = new RandomAccessFile(pactFile, "rw");
            FileLock lock = raf.getChannel().lock();
            try {
                Pact<?> existingPact = DefaultPactReader.INSTANCE.loadPact(this.readFileUtf8(raf));
                MergeResult<Interaction> result = PactMerge.merge(existingPact, pact);
                if (!result.getOk()) {
                    throw (Throwable)new InvalidPactException(result.getMessage());
                }
                raf.seek(0L);
                StringWriter swriter = new StringWriter();
                PrintWriter writer = new PrintWriter(swriter);
                this.writePact(pact, writer, pactSpecVersion);
                String string = swriter.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"swriter.toString()");
                String string2 = string;
                Charset charset2 = Charsets.UTF_8;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] bytes = byArray;
                raf.setLength(bytes.length);
                raf.write(bytes);
            }
            finally {
                lock.release();
                raf.close();
            }
        }
        pactFile.getParentFile().mkdirs();
        Object object = pactFile;
        Charset charset3 = Charsets.UTF_8;
        boolean bl = false;
        File result = object;
        int swriter = 8192;
        boolean bl2 = false;
        Object object2 = result;
        boolean bl3 = false;
        Object object3 = object2;
        boolean bl4 = false;
        object3 = new FileOutputStream((File)object3);
        bl4 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset3);
        bl3 = false;
        BufferedWriter bufferedWriter = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, swriter);
        Writer writer = bufferedWriter;
        object = new PrintWriter(writer);
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)object;
            boolean bl6 = false;
            INSTANCE.writePact(pact, it, pactSpecVersion);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PactWriteMode pactWriteMode() {
        PactWriteMode pactWriteMode;
        String string = System.getProperty("pact.writer.overwrite");
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 3569038: {
                    if (!string2.equals("true")) break;
                    pactWriteMode = PactWriteMode.OVERWRITE;
                    return pactWriteMode;
                }
            }
        }
        pactWriteMode = PactWriteMode.MERGE;
        return pactWriteMode;
    }

    private final String readFileUtf8(RandomAccessFile file) {
        byte[] buffer = new byte[128];
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        file.seek(0L);
        int count = file.read(buffer);
        while (count > 0) {
            data.write(buffer, 0, count);
            count = file.read(buffer);
        }
        byte[] byArray = data.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"data.toByteArray()");
        byte[] byArray2 = byArray;
        Charset charset2 = Charset.forName("UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(\"UTF-8\")");
        Charset charset3 = charset2;
        boolean bl = false;
        return new String(byArray2, charset3);
    }

    private DefaultPactWriter() {
    }

    static {
        DefaultPactWriter defaultPactWriter;
        INSTANCE = defaultPactWriter = new DefaultPactWriter();
    }
}

