/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model.generators;

import au.com.dius.pact.model.generators.ErrorListener;
import au.com.dius.pact.model.generators.ParsedTimeExpression;
import au.com.dius.pact.model.generators.TimeExpression$WhenMappings;
import au.com.dius.pact.support.generators.expressions.Adjustment;
import au.com.dius.pact.support.generators.expressions.TimeBase;
import au.com.dius.pact.support.generators.expressions.TimeExpressionLexer;
import au.com.dius.pact.support.generators.expressions.TimeExpressionParser;
import au.com.dius.pact.support.generators.expressions.TimeOffsetType;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lau/com/dius/pact/model/generators/TimeExpression;", "Lmu/KLogging;", "()V", "executeTimeExpression", "Lcom/github/michaelbull/result/Result;", "Ljava/time/OffsetDateTime;", "", "base", "expression", "parseTimeExpression", "Lau/com/dius/pact/model/generators/ParsedTimeExpression;", "pact-jvm-model"})
public final class TimeExpression
extends KLogging {
    public static final TimeExpression INSTANCE;

    @NotNull
    public final Result<OffsetDateTime, String> executeTimeExpression(@NotNull OffsetDateTime base, @Nullable String expression) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        CharSequence charSequence = expression;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Result result;
            Result result2 = this.parseTimeExpression(expression);
            if (result2 instanceof Err) {
                result = result2;
            } else if (result2 instanceof Ok) {
                OffsetDateTime offsetDateTime;
                OffsetDateTime midnight = OffsetDateTime.of(base.toLocalDate(), LocalTime.MIDNIGHT, ZoneOffset.from(base));
                OffsetDateTime noon = OffsetDateTime.of(base.toLocalDate(), LocalTime.NOON, ZoneOffset.from(base));
                TimeBase valBase = ((ParsedTimeExpression)((Ok)result2).getValue()).getBase();
                if (Intrinsics.areEqual((Object)valBase, (Object)TimeBase.Now.INSTANCE)) {
                    offsetDateTime = base;
                } else if (Intrinsics.areEqual((Object)valBase, (Object)TimeBase.Midnight.INSTANCE)) {
                    offsetDateTime = midnight;
                } else if (Intrinsics.areEqual((Object)valBase, (Object)TimeBase.Noon.INSTANCE)) {
                    offsetDateTime = noon;
                } else if (valBase instanceof TimeBase.Am) {
                    offsetDateTime = midnight.plusHours(((TimeBase.Am)valBase).getHour());
                } else if (valBase instanceof TimeBase.Pm) {
                    offsetDateTime = noon.plusHours(((TimeBase.Pm)valBase).getHour());
                } else if (valBase instanceof TimeBase.Next) {
                    offsetDateTime = base.isBefore(noon) ? noon.plusHours(((TimeBase.Next)valBase).getHour()) : midnight.plusHours(((TimeBase.Next)valBase).getHour());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                OffsetDateTime time = offsetDateTime;
                Iterable $this$forEach$iv = ((ParsedTimeExpression)((Ok)result2).getValue()).getAdjustments();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Adjustment it = (Adjustment)element$iv;
                    boolean bl3 = false;
                    switch (TimeExpression$WhenMappings.$EnumSwitchMapping$2[it.getOperation().ordinal()]) {
                        case 1: {
                            OffsetDateTime offsetDateTime2;
                            switch (TimeExpression$WhenMappings.$EnumSwitchMapping$0[((TimeOffsetType)it.getType()).ordinal()]) {
                                case 1: {
                                    offsetDateTime2 = time.plusHours(it.getValue());
                                    break;
                                }
                                case 2: {
                                    offsetDateTime2 = time.plusMinutes(it.getValue());
                                    break;
                                }
                                case 3: {
                                    offsetDateTime2 = time.plusSeconds(it.getValue());
                                    break;
                                }
                                case 4: {
                                    offsetDateTime2 = time.plus(it.getValue(), ChronoUnit.MILLIS);
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            time = offsetDateTime2;
                            break;
                        }
                        case 2: {
                            OffsetDateTime offsetDateTime3;
                            switch (TimeExpression$WhenMappings.$EnumSwitchMapping$1[((TimeOffsetType)it.getType()).ordinal()]) {
                                case 1: {
                                    offsetDateTime3 = time.minusHours(it.getValue());
                                    break;
                                }
                                case 2: {
                                    offsetDateTime3 = time.minusMinutes(it.getValue());
                                    break;
                                }
                                case 3: {
                                    offsetDateTime3 = time.minusSeconds(it.getValue());
                                    break;
                                }
                                case 4: {
                                    offsetDateTime3 = time.minus(it.getValue(), ChronoUnit.MILLIS);
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            time = offsetDateTime3;
                        }
                    }
                }
                result = (Result)new Ok((Object)time);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return result;
        }
        return (Result)new Ok((Object)base);
    }

    private final Result<ParsedTimeExpression, String> parseTimeExpression(String expression) {
        Result result;
        CodePointCharStream charStream = CharStreams.fromString((String)expression);
        TimeExpressionLexer lexer = new TimeExpressionLexer((CharStream)charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        TimeExpressionParser parser = new TimeExpressionParser((TokenStream)tokens);
        ErrorListener errorListener = new ErrorListener(null, 1, null);
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        TimeExpressionParser.ExpressionContext result2 = parser.expression();
        Collection collection = errorListener.getErrors();
        boolean bl = false;
        if (!collection.isEmpty()) {
            result = (Result)new Err((Object)("Error parsing expression: " + CollectionsKt.joinToString$default((Iterable)errorListener.getErrors(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
        } else {
            TimeBase timeBase = result2.timeBase;
            Intrinsics.checkExpressionValueIsNotNull((Object)timeBase, (String)"result.timeBase");
            List list = result2.adj;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result.adj");
            result = (Result)new Ok((Object)new ParsedTimeExpression(timeBase, list));
        }
        return result;
    }

    private TimeExpression() {
    }

    static {
        TimeExpression timeExpression;
        INSTANCE = timeExpression = new TimeExpression();
    }
}

