/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.provider.junit.InteractionRunner;
import au.com.dius.pact.provider.junit.Provider;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.loader.PactSource;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class PactRunner
extends ParentRunner<InteractionRunner> {
    private final List<InteractionRunner> child;

    public PactRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        List<Pact> pacts;
        Provider providerInfo = clazz.getAnnotation(Provider.class);
        if (providerInfo == null) {
            throw new InitializationError("Provider name should be specified by using " + Provider.class.getName() + " annotation");
        }
        String serviceName = providerInfo.value();
        TestClass testClass = new TestClass(clazz);
        this.child = new ArrayList<InteractionRunner>();
        try {
            pacts = this.getPactSource(testClass).load(serviceName);
        }
        catch (IOException e) {
            throw new InitializationError((Throwable)e);
        }
        for (Pact pact : pacts) {
            this.child.add(new InteractionRunner(testClass, pact));
        }
    }

    protected List<InteractionRunner> getChildren() {
        return this.child;
    }

    protected Description describeChild(InteractionRunner child) {
        return child.getDescription();
    }

    protected void runChild(InteractionRunner interaction, RunNotifier notifier) {
        interaction.run(notifier);
    }

    protected PactLoader getPactSource(TestClass clazz) throws InitializationError {
        PactSource pactSource = (PactSource)clazz.getAnnotation(PactSource.class);
        ArrayList<Annotation> pactLoaders = new ArrayList<Annotation>();
        for (Annotation annotation : clazz.getAnnotations()) {
            if (annotation.annotationType().getAnnotation(PactSource.class) == null) continue;
            pactLoaders.add(annotation);
        }
        if ((pactSource == null ? 0 : 1) + pactLoaders.size() != 1) {
            throw new InitializationError("Exactly one pact source should be set");
        }
        try {
            if (pactSource != null) {
                return pactSource.value().newInstance();
            }
            Annotation annotation = (Annotation)pactLoaders.iterator().next();
            return annotation.annotationType().getAnnotation(PactSource.class).value().getConstructor(annotation.annotationType()).newInstance(annotation);
        }
        catch (Exception e) {
            throw new InitializationError("Error while creating pact source");
        }
    }
}

