/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.provider.junit.loader.PactFolder;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PactFolderLoader
implements PactLoader {
    private final File path;

    public PactFolderLoader(File path) {
        this.path = path;
    }

    public PactFolderLoader(String path) {
        this(new File(path));
    }

    public PactFolderLoader(URL path) {
        this(path == null ? "" : path.getPath());
    }

    public PactFolderLoader(PactFolder pactFolder) {
        this(PactFolderLoader.class.getClassLoader().getResource(pactFolder.value()));
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        File[] files;
        PactReader pactReader = new PactReader();
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        for (File file : files = this.path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        })) {
            Pact pact = (Pact)PactReader.loadPact((Object)file);
            if (!pact.getProvider().getName().equals(providerName)) continue;
            pacts.add(pact);
        }
        return pacts;
    }
}

