/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.model.RequestResponsePact;
import au.com.dius.pact.provider.junit.State;
import au.com.dius.pact.provider.junit.TargetRequestFilter;
import au.com.dius.pact.provider.junit.target.Target;
import au.com.dius.pact.provider.junit.target.TestClassAwareTarget;
import au.com.dius.pact.provider.junit.target.TestTarget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpRequest;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class InteractionRunner
extends Runner {
    private final TestClass testClass;
    private final RequestResponsePact pact;
    private final ConcurrentHashMap<RequestResponseInteraction, Description> childDescriptions = new ConcurrentHashMap();

    public InteractionRunner(TestClass testClass, RequestResponsePact pact) throws InitializationError {
        this.testClass = testClass;
        this.pact = pact;
        this.validate();
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((Class)this.testClass.getJavaClass());
        for (RequestResponseInteraction i : this.pact.getInteractions()) {
            description.addChild(this.describeChild(i));
        }
        return description;
    }

    protected Description describeChild(RequestResponseInteraction interaction) {
        if (!this.childDescriptions.containsKey(interaction)) {
            this.childDescriptions.put(interaction, Description.createTestDescription((Class)this.testClass.getJavaClass(), (String)(this.pact.getConsumer().getName() + " - " + interaction.getDescription())));
        }
        return this.childDescriptions.get(interaction);
    }

    protected void validate() throws InitializationError {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(State.class, false, errors);
        this.validateConstructor(errors);
        this.validateTestTarget(errors);
        this.validateRules(errors);
        this.validateTargetRequestFilters(errors);
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private void validateTargetRequestFilters(List<Throwable> errors) {
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(TargetRequestFilter.class)) {
            method.validatePublicVoid(false, errors);
            if (method.getMethod().getParameterTypes().length != 1) {
                errors.add(new Exception("Method " + method.getName() + " should take only a single HttpRequest parameter"));
                continue;
            }
            if (HttpRequest.class.isAssignableFrom(method.getMethod().getParameterTypes()[0])) continue;
            errors.add(new Exception("Method " + method.getName() + " should take only a single HttpRequest parameter"));
        }
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(annotation)) {
            method.validatePublicVoidNoArg(isStatic, errors);
        }
    }

    protected void validateConstructor(List<Throwable> errors) {
        if (!this.hasOneConstructor()) {
            errors.add(new Exception("Test class should have exactly one public constructor"));
        }
        if (!this.testClass.isANonStaticInnerClass() && this.hasOneConstructor() && this.testClass.getOnlyConstructor().getParameterTypes().length != 0) {
            errors.add(new Exception("Test class should have exactly one public zero-argument constructor"));
        }
    }

    protected boolean hasOneConstructor() {
        return this.testClass.getJavaClass().getConstructors().length == 1;
    }

    protected void validateTestTarget(List<Throwable> errors) {
        List annotatedFields = this.testClass.getAnnotatedFields(TestTarget.class);
        if (annotatedFields.size() != 1) {
            errors.add(new Exception("Test class should have exactly one field annotated with " + TestTarget.class.getName()));
        } else if (!Target.class.isAssignableFrom(((FrameworkField)annotatedFields.get(0)).getType())) {
            errors.add(new Exception("Field annotated with " + TestTarget.class.getName() + " should implement " + Target.class.getName() + " interface"));
        }
    }

    protected void validateRules(List<Throwable> errors) {
        RuleMemberValidator.RULE_VALIDATOR.validate(this.testClass, errors);
        RuleMemberValidator.RULE_METHOD_VALIDATOR.validate(this.testClass, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        for (RequestResponseInteraction interaction : this.pact.getInteractions()) {
            Description description = this.describeChild(interaction);
            notifier.fireTestStarted(description);
            try {
                this.interactionBlock(interaction).evaluate();
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(description, e));
            }
            finally {
                notifier.fireTestFinished(description);
            }
        }
    }

    protected Object createTest() throws Exception {
        return this.testClass.getOnlyConstructor().newInstance(new Object[0]);
    }

    protected Statement interactionBlock(final RequestResponseInteraction interaction) {
        Object test;
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return InteractionRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        final Target target = (Target)this.testClass.getAnnotatedFieldValues(test, TestTarget.class, Target.class).get(0);
        if (target instanceof TestClassAwareTarget) {
            ((TestClassAwareTarget)target).setTestClass(this.testClass, test);
        }
        Statement statement = new Statement(){

            public void evaluate() throws Throwable {
                target.testInteraction(InteractionRunner.this.pact.getConsumer().getName(), (Interaction)interaction);
            }
        };
        statement = this.withStateChanges(interaction, test, statement);
        statement = this.withBefores(interaction, test, statement);
        statement = this.withRules(interaction, test, statement);
        statement = this.withAfters(interaction, test, statement);
        return statement;
    }

    protected Statement withStateChanges(RequestResponseInteraction interaction, Object target, Statement statement) {
        if (interaction.getProviderState() != null && !interaction.getProviderState().isEmpty()) {
            String state = interaction.getProviderState();
            ArrayList<FrameworkMethod> onStateChange = new ArrayList<FrameworkMethod>();
            for (FrameworkMethod ann : this.testClass.getAnnotatedMethods(State.class)) {
                if (!ArrayUtils.contains((Object[])((State)ann.getAnnotation(State.class)).value(), (Object)state)) continue;
                onStateChange.add(ann);
            }
            return onStateChange.isEmpty() ? statement : new RunBefores(statement, onStateChange, target);
        }
        return statement;
    }

    protected Statement withBefores(RequestResponseInteraction interaction, Object target, Statement statement) {
        List befores = this.testClass.getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
    }

    protected Statement withAfters(RequestResponseInteraction interaction, Object target, Statement statement) {
        List afters = this.testClass.getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
    }

    protected Statement withRules(RequestResponseInteraction interaction, Object target, Statement statement) {
        List testRules = this.testClass.getAnnotatedMethodValues(target, Rule.class, TestRule.class);
        testRules.addAll(this.testClass.getAnnotatedFieldValues(target, Rule.class, TestRule.class));
        return testRules.isEmpty() ? statement : new RunRules(statement, (Iterable)testRules, this.describeChild(interaction));
    }
}

