/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.junit.Provider;
import au.com.dius.pact.provider.junit.TargetRequestFilter;
import au.com.dius.pact.provider.junit.VerificationReports;
import au.com.dius.pact.provider.junit.sysprops.SystemPropertyResolver;
import au.com.dius.pact.provider.junit.sysprops.ValueResolver;
import au.com.dius.pact.provider.junit.target.TestClassAwareTarget;
import au.com.dius.pact.provider.reporters.ReporterManager;
import au.com.dius.pact.provider.reporters.VerifierReporter;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTarget
implements TestClassAwareTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTarget.class);
    private final String path;
    private final String host;
    private final int port;
    private final String protocol;
    private TestClass testClass;
    private Object testTarget;
    private ValueResolver valueResolver = new SystemPropertyResolver();

    public HttpTarget(String host, int port) {
        this("http", host, port);
    }

    public HttpTarget(int port) {
        this("http", "localhost", port);
    }

    public HttpTarget(String protocol, String host, int port) {
        this(protocol, host, port, "/");
    }

    public HttpTarget(String protocol, String host, int port, String path) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.path = path;
    }

    public HttpTarget(URL url) {
        this(url.getProtocol() == null ? "http" : url.getProtocol(), url.getHost(), url.getPort() == -1 ? 8080 : url.getPort(), url.getPath() == null ? "/" : url.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testInteraction(String consumerName, Interaction interaction) {
        if (!(interaction instanceof RequestResponseInteraction)) {
            throw new AssertionError((Object)("HttpTarget can only validate RequestResponseInteractions. Received a " + interaction.getClass().getSimpleName()));
        }
        RequestResponseInteraction rri = (RequestResponseInteraction)interaction;
        ProviderInfo provider = this.getProviderInfo();
        ConsumerInfo consumer = new ConsumerInfo(consumerName);
        ProviderVerifier verifier = this.setupVerifier(rri, provider, consumer);
        HashMap<String, Object> failures = new HashMap<String, Object>();
        verifier.verifyResponseFromProvider(provider, (Object)interaction, interaction.getDescription(), failures);
        try {
            if (!failures.isEmpty()) {
                verifier.displayFailures(failures);
                throw this.getAssertionError(failures);
            }
        }
        finally {
            verifier.finialiseReports();
        }
    }

    private ProviderVerifier setupVerifier(RequestResponseInteraction interaction, ProviderInfo provider, ConsumerInfo consumer) {
        ProviderVerifier verifier = new ProviderVerifier();
        this.setupReporters(verifier, provider.getName(), interaction.getDescription());
        verifier.initialiseReporters(provider);
        verifier.reportVerificationForConsumer(consumer, provider);
        if (interaction.getProviderState() != null) {
            verifier.reportStateForInteraction(interaction.getProviderState(), provider, consumer, true);
        }
        verifier.reportInteractionDescription((Object)interaction);
        return verifier;
    }

    private void setupReporters(ProviderVerifier verifier, String name, String description) {
        String reportDirectory = "target/pact/reports";
        String[] reports = new String[]{};
        boolean reportingEnabled = false;
        VerificationReports verificationReports = (VerificationReports)this.testClass.getAnnotation(VerificationReports.class);
        if (verificationReports != null) {
            reportingEnabled = true;
            reportDirectory = verificationReports.reportDir();
            reports = verificationReports.value();
        } else if (this.valueResolver.propertyDefined("pact.verification.reports")) {
            reportingEnabled = true;
            reportDirectory = this.valueResolver.resolveValue("pact.verification.reportDir:" + reportDirectory);
            reports = this.valueResolver.resolveValue("pact.verification.reports:").split(",");
        }
        if (reportingEnabled) {
            File reportDir = new File(reportDirectory);
            reportDir.mkdirs();
            ArrayList<VerifierReporter> reportsList = new ArrayList<VerifierReporter>();
            for (String report : reports) {
                if (report.isEmpty()) continue;
                VerifierReporter reporter = ReporterManager.createReporter((String)report.trim());
                reporter.setReportDir(reportDir);
                reporter.setReportFile(new File(reportDir, name + " - " + description + reporter.getExt()));
                reportsList.add(reporter);
            }
            verifier.setReporters(reportsList);
        }
    }

    private ProviderInfo getProviderInfo() {
        List methods;
        Provider provider = (Provider)this.testClass.getAnnotation(Provider.class);
        ProviderInfo providerInfo = new ProviderInfo(provider.value());
        providerInfo.setPort(Integer.valueOf(this.port));
        providerInfo.setHost((Object)this.host);
        providerInfo.setProtocol(this.protocol);
        providerInfo.setPath(this.path);
        if (this.testClass != null && !(methods = this.testClass.getAnnotatedMethods(TargetRequestFilter.class)).isEmpty()) {
            providerInfo.setRequestFilter((Object)new Closure(){

                public void execute(Object httpRequest) {
                    for (FrameworkMethod method : methods) {
                        try {
                            method.invokeExplosively(HttpTarget.this.testTarget, new Object[]{httpRequest});
                        }
                        catch (Throwable t) {
                            LOGGER.error("Request filter failed with an exception", t);
                            throw new AssertionError((Object)("Request filter method " + method.getName() + " failed with an exception"));
                        }
                    }
                }
            });
        }
        return providerInfo;
    }

    private AssertionError getAssertionError(Map<String, Object> mismatches) {
        String error = SystemUtils.LINE_SEPARATOR;
        int count = 0;
        for (Object mismatch : mismatches.values()) {
            String errPrefix = String.valueOf(count++) + " - ";
            error = mismatch instanceof Throwable ? error + errPrefix + this.exceptionMessage((Throwable)mismatch, errPrefix.length()) : (mismatch instanceof Map ? error + errPrefix + this.convertMapToErrorString((Map)mismatch) : error + errPrefix + mismatch.toString());
            error = error + SystemUtils.LINE_SEPARATOR;
        }
        return new AssertionError((Object)error);
    }

    private String exceptionMessage(Throwable err, int prefixLength) {
        String message = err.getMessage();
        if (message.contains("\n")) {
            String padString = StringUtils.leftPad((String)"", (int)prefixLength);
            String[] lines = message.split("\n");
            message = lines[0] + SystemUtils.LINE_SEPARATOR;
            for (int line = 1; line < lines.length; ++line) {
                message = message + padString + lines[line] + SystemUtils.LINE_SEPARATOR;
            }
        }
        return message;
    }

    private String convertMapToErrorString(Map mismatches) {
        if (mismatches.containsKey("comparison")) {
            Object comparison = mismatches.get("comparison");
            if (mismatches.containsKey("diff")) {
                return this.mapToString((Map)comparison);
            }
            if (comparison instanceof Map) {
                return this.mapToString((Map)comparison);
            }
            return String.valueOf(comparison);
        }
        return this.mapToString(mismatches);
    }

    private String mapToString(Map comparison) {
        String map = "";
        Iterator iterator = comparison.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            map = map + String.valueOf(e.getKey()) + " -> " + e.getValue() + SystemUtils.LINE_SEPARATOR;
        }
        return map;
    }

    @Override
    public void setTestClass(TestClass testClass, Object testTarget) {
        this.testClass = testClass;
        this.testTarget = testTarget;
    }

    public ValueResolver getValueResolver() {
        return this.valueResolver;
    }

    public void setValueResolver(ValueResolver valueResolver) {
        this.valueResolver = valueResolver;
    }
}

