/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.provider.junit.loader.PactBroker;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactBrokerLoader
implements PactLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactBrokerLoader.class);
    private static final String PACT_URL_PATTERN = "{0}://{1}:{2}/pacts/provider/{3}/latest";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final String pactBrokerHost;
    private final int pactBrokerPort;
    private final String pactBrokerProtocol;
    private final Retryer<HttpResponse> retryer = RetryerBuilder.newBuilder().retryIfResult((Predicate)new Predicate<HttpResponse>(){

        public boolean apply(@Nullable HttpResponse response) {
            return response.getStatusLine().getStatusCode() >= 500;
        }
    }).withWaitStrategy(WaitStrategies.exponentialWait((long)100L, (long)1L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)5000L)).build();

    public PactBrokerLoader(String pactBrokerHost, int pactBrokerPort, String pactBrokerProtocol) {
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerProtocol = pactBrokerProtocol;
    }

    public PactBrokerLoader(PactBroker pactBroker) {
        this(pactBroker.host(), pactBroker.port(), pactBroker.protocol());
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        HttpResponse httpResponse;
        final String uri = MessageFormat.format(PACT_URL_PATTERN, this.pactBrokerProtocol, this.pactBrokerHost, Integer.toString(this.pactBrokerPort), providerName);
        try {
            httpResponse = (HttpResponse)this.retryer.call((Callable)new Callable<HttpResponse>(){

                @Override
                public HttpResponse call() throws Exception {
                    return Request.Get((String)uri).setHeader("Accept", "application/hal+json").execute().returnResponse();
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Was not able load pacts from broker", e);
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            LOGGER.warn("There are no pacts found for the service '" + providerName + "'");
            return Collections.emptyList();
        }
        if (statusCode / 100 != 2) {
            throw new RuntimeException("Pact broker responded with status: " + statusCode + "\n payload: '" + IOUtils.toString((InputStream)httpResponse.getEntity().getContent()) + "'");
        }
        JsonNode fullList = OBJECT_MAPPER.readTree(httpResponse.getEntity().getContent());
        JsonNode path = fullList.path("_links").path("pacts");
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        for (JsonNode jsonNode : path) {
            pacts.add(PactReader.loadPact((Object)jsonNode.get("href").asText()));
        }
        return pacts;
    }
}

