/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.BodyMismatch;
import au.com.dius.pact.model.BodyTypeMismatch;
import au.com.dius.pact.model.HeaderMismatch;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.model.Response;
import au.com.dius.pact.model.ResponseMatching$;
import au.com.dius.pact.model.ResponsePartMismatch;
import au.com.dius.pact.model.StatusMismatch;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.junit.target.Target;
import java.util.Map;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class HttpTarget
implements Target {
    private final String host;
    private final int port;
    private final String protocol;

    public HttpTarget(String host, int port) {
        this("http", host, port);
    }

    public HttpTarget(int port) {
        this("http", "localhost", port);
    }

    public HttpTarget(String protocol, String host, int port) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    @Override
    public void testInteraction(Interaction interaction) {
        ProviderClient providerClient = new ProviderClient();
        providerClient.setProvider((Object)this.getProviderInfo());
        RequestResponseInteraction reqResInteraction = (RequestResponseInteraction)interaction;
        providerClient.setRequest(reqResInteraction.getRequest());
        Map actualResponse = (Map)providerClient.makeRequest();
        Seq mismatches = ResponseMatching$.MODULE$.responseMismatches(reqResInteraction.getResponse(), new Response(Integer.valueOf((Integer)actualResponse.get("statusCode")), (Map)actualResponse.get("headers"), (String)actualResponse.get("data")));
        if (!mismatches.isEmpty()) {
            throw this.getAssertionError((Seq<ResponsePartMismatch>)mismatches);
        }
    }

    private ProviderInfo getProviderInfo() {
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.setPort(Integer.valueOf(this.port));
        providerInfo.setHost((Object)this.host);
        providerInfo.setProtocol(this.protocol);
        return providerInfo;
    }

    private AssertionError getAssertionError(Seq<ResponsePartMismatch> mismatches) {
        StringBuilder result = new StringBuilder();
        for (ResponsePartMismatch mismatch : JavaConversions.seqAsJavaList(mismatches)) {
            result.append("\n");
            if (mismatch instanceof StatusMismatch) {
                StatusMismatch statusMismatch = (StatusMismatch)mismatch;
                result.append("StatusMismatch - Expected status " + statusMismatch.expected() + " but was " + statusMismatch.actual());
                continue;
            }
            if (mismatch instanceof HeaderMismatch) {
                result.append(((HeaderMismatch)mismatch).description());
                continue;
            }
            if (mismatch instanceof BodyTypeMismatch) {
                BodyTypeMismatch bodyTypeMismatch = (BodyTypeMismatch)mismatch;
                result.append("BodyTypeMismatch - Expected body to have type '" + bodyTypeMismatch.expected() + "' but was '" + bodyTypeMismatch.actual() + "'");
                continue;
            }
            if (mismatch instanceof BodyMismatch) {
                result.append(((BodyMismatch)mismatch).description());
                continue;
            }
            result.append(mismatch.toString());
        }
        return new AssertionError((Object)result.toString());
    }
}

