/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.RequestResponsePact;
import au.com.dius.pact.provider.junit.Consumer;
import au.com.dius.pact.provider.junit.InteractionRunner;
import au.com.dius.pact.provider.junit.Provider;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.loader.PactSource;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactRunner
extends ParentRunner<InteractionRunner> {
    private final Logger LOGGER = LoggerFactory.getLogger(PactRunner.class);
    private final List<InteractionRunner> child;

    public PactRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        Provider providerInfo = clazz.getAnnotation(Provider.class);
        if (providerInfo == null) {
            throw new InitializationError("Provider name should be specified by using " + Provider.class.getName() + " annotation");
        }
        String serviceName = providerInfo.value();
        Consumer consumerInfo = clazz.getAnnotation(Consumer.class);
        String consumerName = consumerInfo != null ? consumerInfo.value() : null;
        TestClass testClass = new TestClass(clazz);
        this.child = new ArrayList<InteractionRunner>();
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        try {
            List<Pact> list = this.getPactSource(testClass).load(serviceName);
            for (Pact p : list) {
                if (consumerName != null && !p.getConsumer().getName().equals(consumerName)) continue;
                pacts.add(p);
            }
        }
        catch (IOException e) {
            throw new InitializationError((Throwable)e);
        }
        if (pacts.isEmpty()) {
            throw new InitializationError("Did not find any pact files for provider " + providerInfo.value());
        }
        for (Pact pact : pacts) {
            this.child.add(new InteractionRunner(testClass, (RequestResponsePact)pact));
        }
    }

    protected List<InteractionRunner> getChildren() {
        return this.child;
    }

    protected Description describeChild(InteractionRunner child) {
        return child.getDescription();
    }

    protected void runChild(InteractionRunner interaction, RunNotifier notifier) {
        interaction.run(notifier);
    }

    protected PactLoader getPactSource(TestClass clazz) throws InitializationError {
        PactSource pactSource = (PactSource)clazz.getAnnotation(PactSource.class);
        ArrayList<Annotation> pactLoaders = new ArrayList<Annotation>();
        for (Annotation annotation : clazz.getAnnotations()) {
            if (annotation.annotationType().getAnnotation(PactSource.class) == null) continue;
            pactLoaders.add(annotation);
        }
        if ((pactSource == null ? 0 : 1) + pactLoaders.size() != 1) {
            throw new InitializationError("Exactly one pact source should be set");
        }
        try {
            if (pactSource != null) {
                Class<? extends PactLoader> pactLoaderClass = pactSource.value();
                try {
                    Constructor<? extends PactLoader> contructorWithClass = pactLoaderClass.getDeclaredConstructor(Class.class);
                    contructorWithClass.setAccessible(true);
                    return contructorWithClass.newInstance(clazz.getJavaClass());
                }
                catch (NoSuchMethodException e) {
                    return pactLoaderClass.newInstance();
                }
            }
            Annotation annotation = (Annotation)pactLoaders.iterator().next();
            return annotation.annotationType().getAnnotation(PactSource.class).value().getConstructor(annotation.annotationType()).newInstance(annotation);
        }
        catch (InstantiationException e) {
            this.LOGGER.error("Error while creating pact source", (Throwable)e);
            throw new InitializationError("Error while creating pact source");
        }
        catch (IllegalAccessException e) {
            this.LOGGER.error("Error while creating pact source", (Throwable)e);
            throw new InitializationError("Error while creating pact source");
        }
        catch (NoSuchMethodException e) {
            this.LOGGER.error("Error while creating pact source", (Throwable)e);
            throw new InitializationError("Error while creating pact source");
        }
        catch (InvocationTargetException e) {
            this.LOGGER.error("Error while creating pact source", (Throwable)e);
            throw new InitializationError("Error while creating pact source");
        }
    }
}

