/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.provider.junit.loader.PactBroker;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.sysprops.PactRunnerExpressionParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactBrokerLoader
implements PactLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactBrokerLoader.class);
    private static final String PACT_URL_PATTERN = "/pacts/provider/{0}/latest";
    private static final String PACT_URL_PATTERN_WITH_TAG = "/pacts/provider/{0}/latest/{1}";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final String pactBrokerHost;
    private final String pactBrokerPort;
    private final String pactBrokerProtocol;
    private final List<String> pactBrokerTags;
    private final Retryer<HttpResponse> retryer = RetryerBuilder.newBuilder().retryIfResult((Predicate)new Predicate<HttpResponse>(){

        public boolean apply(@Nullable HttpResponse response) {
            return response.getStatusLine().getStatusCode() >= 500;
        }
    }).withWaitStrategy(WaitStrategies.exponentialWait((long)100L, (long)1L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)5000L)).build();
    private Callable<HttpResponse> httpResponseCallable;

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol) {
        this(pactBrokerHost, pactBrokerPort, pactBrokerProtocol, Collections.singletonList("latest"));
    }

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol, List<String> tags) {
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerProtocol = pactBrokerProtocol;
        this.pactBrokerTags = tags;
    }

    public PactBrokerLoader(PactBroker pactBroker) {
        this(pactBroker.host(), pactBroker.port(), pactBroker.protocol(), Arrays.asList(pactBroker.tags()));
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        for (String tag : this.pactBrokerTags) {
            pacts.addAll(this.loadPactsForProvider(providerName, tag));
        }
        return pacts;
    }

    private List<Pact> loadPactsForProvider(String providerName, String tag) throws IOException {
        HttpResponse httpResponse;
        LOGGER.debug("Loading pacts from pact broker for provider " + providerName + " and tag " + tag);
        try {
            URIBuilder uriBuilder = new URIBuilder().setScheme(PactRunnerExpressionParser.parseExpressions(this.pactBrokerProtocol)).setHost(PactRunnerExpressionParser.parseExpressions(this.pactBrokerHost)).setPort(Integer.parseInt(PactRunnerExpressionParser.parseExpressions(this.pactBrokerPort)));
            if (tag.equals("latest")) {
                uriBuilder.setPath(MessageFormat.format(PACT_URL_PATTERN, providerName));
            } else {
                uriBuilder.setPath(MessageFormat.format(PACT_URL_PATTERN_WITH_TAG, providerName, tag));
            }
            final URI brokerUri = uriBuilder.build();
            if (this.httpResponseCallable == null) {
                this.httpResponseCallable = new Callable<HttpResponse>(){

                    @Override
                    public HttpResponse call() throws Exception {
                        return Request.Get((URI)brokerUri).setHeader("Accept", "application/hal+json").execute().returnResponse();
                    }
                };
            }
            httpResponse = (HttpResponse)this.retryer.call(this.httpResponseCallable);
        }
        catch (Exception e) {
            throw new IOException("Was not able load pacts from broker", e);
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            LOGGER.warn("There are no pacts found for the service '" + providerName + "' and tag '" + tag + "'");
            return Collections.emptyList();
        }
        if (statusCode / 100 != 2) {
            throw new RuntimeException("Pact broker responded with status: " + statusCode + "\n payload: '" + IOUtils.toString((InputStream)httpResponse.getEntity().getContent()) + "'");
        }
        JsonNode fullList = OBJECT_MAPPER.readTree(httpResponse.getEntity().getContent());
        JsonNode path = fullList.path("_links").path("pacts");
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        for (JsonNode jsonNode : path) {
            pacts.add(PactReader.loadPact((Object)jsonNode.get("href").asText()));
        }
        return pacts;
    }

    public Callable<HttpResponse> getHttpResponseCallable() {
        return this.httpResponseCallable;
    }

    public void setHttpResponseCallable(Callable<HttpResponse> httpResponseCallable) {
        this.httpResponseCallable = httpResponseCallable;
    }
}

