/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.sysprops;

import au.com.dius.pact.provider.junit.sysprops.ValueResolver;
import org.apache.commons.lang3.StringUtils;

public class SystemPropertyResolver
implements ValueResolver {
    @Override
    public String resolveValue(String property) {
        PropertyValueTuple tuple = new PropertyValueTuple(property).invoke();
        String propertyValue = System.getProperty(tuple.getPropertyName());
        if (propertyValue == null) {
            propertyValue = System.getenv(tuple.getPropertyName());
        }
        if (propertyValue == null) {
            propertyValue = tuple.getDefaultValue();
        }
        if (StringUtils.isEmpty((CharSequence)propertyValue)) {
            throw new RuntimeException("Could not resolve property \"" + tuple.getPropertyName() + "\" in the system properties or environment variables and no default value is supplied");
        }
        return propertyValue;
    }

    private class PropertyValueTuple {
        private String propertyName;
        private String defaultValue;

        public PropertyValueTuple(String property) {
            this.propertyName = property;
            this.defaultValue = null;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public PropertyValueTuple invoke() {
            if (this.propertyName.contains(":")) {
                String[] kv = this.propertyName.split(":");
                this.propertyName = kv[0];
                if (kv.length > 1) {
                    this.defaultValue = kv[1];
                }
            }
            return this;
        }
    }
}

