/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.BodyMismatch;
import au.com.dius.pact.model.BodyTypeMismatch;
import au.com.dius.pact.model.HeaderMismatch;
import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.model.Response;
import au.com.dius.pact.model.ResponseMatching$;
import au.com.dius.pact.model.ResponsePartMismatch;
import au.com.dius.pact.model.StatusMismatch;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.junit.TargetRequestFilter;
import au.com.dius.pact.provider.junit.target.TestClassAwareTarget;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class HttpTarget
implements TestClassAwareTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTarget.class);
    private final String path;
    private final String host;
    private final int port;
    private final String protocol;
    private TestClass testClass;
    private Object testTarget;

    public HttpTarget(String host, int port) {
        this("http", host, port);
    }

    public HttpTarget(int port) {
        this("http", "localhost", port);
    }

    public HttpTarget(String protocol, String host, int port) {
        this(protocol, host, port, "/");
    }

    public HttpTarget(String protocol, String host, int port, String path) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.path = path;
    }

    public HttpTarget(URL url) {
        this(url.getProtocol() == null ? "http" : url.getProtocol(), url.getHost(), url.getPort() == -1 ? 8080 : url.getPort(), url.getPath() == null ? "/" : url.getPath());
    }

    @Override
    public void testInteraction(Interaction i) {
        RequestResponseInteraction interaction = (RequestResponseInteraction)i;
        ProviderClient providerClient = new ProviderClient();
        providerClient.setProvider((Object)this.getProviderInfo());
        providerClient.setRequest(interaction.getRequest());
        Map actualResponse = (Map)providerClient.makeRequest();
        Seq mismatches = ResponseMatching$.MODULE$.responseMismatches(interaction.getResponse(), new Response(Integer.valueOf((Integer)actualResponse.get("statusCode")), (Map)actualResponse.get("headers"), OptionalBody.body((String)((String)actualResponse.get("data")))));
        if (!mismatches.isEmpty()) {
            throw this.getAssertionError((Seq<ResponsePartMismatch>)mismatches);
        }
    }

    private ProviderInfo getProviderInfo() {
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.setPort(Integer.valueOf(this.port));
        providerInfo.setHost((Object)this.host);
        providerInfo.setProtocol(this.protocol);
        providerInfo.setPath(this.path);
        final List methods = this.testClass.getAnnotatedMethods(TargetRequestFilter.class);
        if (this.testClass != null && !methods.isEmpty()) {
            providerInfo.setRequestFilter((Object)new Closure(){

                public void execute(Object httpRequest) {
                    for (FrameworkMethod method : methods) {
                        try {
                            method.invokeExplosively(HttpTarget.this.testTarget, new Object[]{httpRequest});
                        }
                        catch (Throwable t) {
                            LOGGER.error("Request filter failed with an exception", t);
                            throw new AssertionError((Object)("Request filter method " + method.getName() + " failed with an exception"));
                        }
                    }
                }
            });
        }
        return providerInfo;
    }

    private AssertionError getAssertionError(Seq<ResponsePartMismatch> mismatches) {
        StringBuilder result = new StringBuilder();
        for (ResponsePartMismatch mismatch : JavaConversions.seqAsJavaList(mismatches)) {
            result.append("\n");
            if (mismatch instanceof StatusMismatch) {
                StatusMismatch statusMismatch = (StatusMismatch)mismatch;
                result.append("StatusMismatch - Expected status " + statusMismatch.expected() + " but was " + statusMismatch.actual());
                continue;
            }
            if (mismatch instanceof HeaderMismatch) {
                result.append(((HeaderMismatch)mismatch).description());
                continue;
            }
            if (mismatch instanceof BodyTypeMismatch) {
                BodyTypeMismatch bodyTypeMismatch = (BodyTypeMismatch)mismatch;
                result.append("BodyTypeMismatch - Expected body to have type '" + bodyTypeMismatch.expected() + "' but was '" + bodyTypeMismatch.actual() + "'");
                continue;
            }
            if (mismatch instanceof BodyMismatch) {
                result.append(((BodyMismatch)mismatch).description());
                continue;
            }
            result.append(mismatch.toString());
        }
        return new AssertionError((Object)result.toString());
    }

    @Override
    public void setTestClass(TestClass testClass, Object testTarget) {
        this.testClass = testClass;
        this.testTarget = testTarget;
    }
}

