/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.provider.junit.loader.PactFolder;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PactFolderLoader
implements PactLoader {
    private final String path;

    public PactFolderLoader(File path) {
        this(path.getPath());
    }

    public PactFolderLoader(String path) {
        this.path = path;
    }

    @Deprecated
    public PactFolderLoader(URL path) {
        this(path == null ? "" : path.getPath());
    }

    public PactFolderLoader(PactFolder pactFolder) {
        this(pactFolder.value());
    }

    @Override
    public List<Pact> load(String providerName) throws IOException {
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        File pactFolder = this.resolvePath();
        File[] files = pactFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        });
        if (files != null) {
            for (File file : files) {
                Pact pact = PactReader.loadPact((Object)file);
                if (!pact.getProvider().getName().equals(providerName)) continue;
                pacts.add(pact);
            }
        }
        return pacts;
    }

    public Map<Pact, File> loadPactsWithFiles(String providerName) throws IOException {
        HashMap<Pact, File> pacts = new HashMap<Pact, File>();
        File pactFolder = this.resolvePath();
        File[] files = pactFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        });
        if (files != null) {
            for (File file : files) {
                Pact pact = PactReader.loadPact((Object)file);
                if (!pact.getProvider().getName().equals(providerName)) continue;
                pacts.put(pact, file);
            }
        }
        return pacts;
    }

    private File resolvePath() {
        File file = new File(this.path);
        URL resourcePath = PactFolderLoader.class.getClassLoader().getResource(this.path);
        if (resourcePath != null) {
            file = new File(resourcePath.getPath());
        }
        return file;
    }
}

