/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.junit.VerificationReports;
import au.com.dius.pact.provider.junit.sysprops.SystemPropertyResolver;
import au.com.dius.pact.provider.junit.sysprops.ValueResolver;
import au.com.dius.pact.provider.junit.target.TestClassAwareTarget;
import au.com.dius.pact.provider.reporters.ReporterManager;
import au.com.dius.pact.provider.reporters.VerifierReporter;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.junit.runners.model.TestClass;

public abstract class BaseTarget
implements TestClassAwareTarget {
    protected TestClass testClass;
    protected Object testTarget;
    protected ValueResolver valueResolver = new SystemPropertyResolver();

    @Override
    public abstract void testInteraction(String var1, Interaction var2);

    protected abstract ProviderInfo getProviderInfo();

    protected abstract ProviderVerifier setupVerifier(Interaction var1, ProviderInfo var2, ConsumerInfo var3);

    protected void setupReporters(ProviderVerifier verifier, String name, String description) {
        String reportDirectory = "target/pact/reports";
        Object[] reports = new String[]{};
        boolean reportingEnabled = false;
        VerificationReports verificationReports = (VerificationReports)this.testClass.getAnnotation(VerificationReports.class);
        if (verificationReports != null) {
            reportingEnabled = true;
            reportDirectory = verificationReports.reportDir();
            reports = verificationReports.value();
        } else if (this.valueResolver.propertyDefined("pact.verification.reports")) {
            reportingEnabled = true;
            reportDirectory = this.valueResolver.resolveValue("pact.verification.reportDir:" + reportDirectory);
            reports = this.valueResolver.resolveValue("pact.verification.reports:").split(",");
        }
        if (reportingEnabled) {
            File reportDir = new File(reportDirectory);
            reportDir.mkdirs();
            verifier.setReporters((Object)Seq.of((Object[])reports).filter(r -> !r.isEmpty()).map(r -> {
                VerifierReporter reporter = ReporterManager.createReporter((String)r.trim());
                reporter.setReportDir(reportDir);
                reporter.setReportFile(new File(reportDir, name + " - " + description + reporter.getExt()));
                return reporter;
            }).toList());
        }
    }

    protected AssertionError getAssertionError(Map<String, Object> mismatches) {
        String error = System.lineSeparator() + Seq.seq(mismatches.values()).zipWithIndex().map(i -> {
            String errPrefix = String.valueOf(i.v2) + " - ";
            if (i.v1 instanceof Throwable) {
                return errPrefix + this.exceptionMessage((Throwable)i.v1, errPrefix.length());
            }
            if (i.v1 instanceof Map) {
                return errPrefix + this.convertMapToErrorString((Map)i.v1);
            }
            return errPrefix + i.v1.toString();
        }).toString((CharSequence)System.lineSeparator());
        return new AssertionError((Object)error);
    }

    private String exceptionMessage(Throwable err, int prefixLength) {
        String message = err.getMessage();
        if (message.contains("\n")) {
            String padString = StringUtils.leftPad((String)"", (int)prefixLength);
            Tuple2 lines = Seq.of((Object[])message.split("\n")).splitAtHead();
            return ((Optional)lines.v1).orElse("") + System.lineSeparator() + ((Seq)lines.v2).map(line -> padString + line).toString((CharSequence)System.lineSeparator());
        }
        return message;
    }

    private String convertMapToErrorString(Map mismatches) {
        if (mismatches.containsKey("comparison")) {
            Object comparison = mismatches.get("comparison");
            if (mismatches.containsKey("diff")) {
                return this.mapToString((Map)comparison);
            }
            if (comparison instanceof Map) {
                return this.mapToString((Map)comparison);
            }
            return String.valueOf(comparison);
        }
        return this.mapToString(mismatches);
    }

    private String mapToString(Map comparison) {
        return comparison.entrySet().stream().map(e -> String.valueOf(((Map.Entry)e).getKey()) + " -> " + ((Map.Entry)e).getValue()).collect(Collectors.joining(System.lineSeparator())).toString();
    }

    @Override
    public void setTestClass(TestClass testClass, Object testTarget) {
        this.testClass = testClass;
        this.testTarget = testTarget;
    }

    public ValueResolver getValueResolver() {
        return this.valueResolver;
    }

    public void setValueResolver(ValueResolver valueResolver) {
        this.valueResolver = valueResolver;
    }
}

