/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.sysprops;

import au.com.dius.pact.provider.junit.sysprops.SystemPropertyResolver;
import au.com.dius.pact.provider.junit.sysprops.ValueResolver;
import com.google.common.base.Strings;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PactRunnerExpressionParser {
    public static final String VALUES_SEPARATOR = ",";
    public static final String START_EXPRESSION = "${";
    public static final char END_EXPRESSION = '}';

    private PactRunnerExpressionParser() {
    }

    public static String parseExpression(String value) {
        return PactRunnerExpressionParser.parseExpression(value, new SystemPropertyResolver());
    }

    public static List<String> parseListExpression(String value) {
        return PactRunnerExpressionParser.parseListExpression(value, new SystemPropertyResolver());
    }

    public static List<String> parseListExpression(String value, ValueResolver valueResolver) {
        return Stream.of(PactRunnerExpressionParser.replaceExpressions(value, valueResolver).split(VALUES_SEPARATOR)).filter(str -> !Strings.isNullOrEmpty((String)str)).collect(Collectors.toList());
    }

    public static String parseExpression(String value, ValueResolver valueResolver) {
        if (value.contains(START_EXPRESSION)) {
            return PactRunnerExpressionParser.replaceExpressions(value, valueResolver);
        }
        return value;
    }

    private static String replaceExpressions(String value, ValueResolver valueResolver) {
        StringJoiner joiner = new StringJoiner("");
        String buffer = value;
        int position = buffer.indexOf(START_EXPRESSION);
        while (position >= 0) {
            int endPosition;
            if (position > 0) {
                joiner.add(buffer.substring(0, position));
            }
            if ((endPosition = buffer.indexOf(125, position)) < 0) {
                throw new RuntimeException("Missing closing brace in expression string \"" + value + "]\"");
            }
            String expression = "";
            if (endPosition - position > 2) {
                expression = valueResolver.resolveValue(buffer.substring(position + 2, endPosition));
            }
            joiner.add(expression);
            buffer = buffer.substring(endPosition + 1);
            position = buffer.indexOf(START_EXPRESSION);
        }
        joiner.add(buffer);
        return joiner.toString();
    }
}

