/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.HttpClientFactory;
import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.junit.Provider;
import au.com.dius.pact.provider.junit.TargetRequestFilter;
import au.com.dius.pact.provider.junit.target.BaseTarget;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

public class HttpTarget
extends BaseTarget {
    private final String path;
    private final String host;
    protected int port;
    private final String protocol;
    private final boolean insecure;

    public HttpTarget(String host, int port) {
        this("http", host, port);
    }

    public HttpTarget(int port) {
        this("http", "localhost", port);
    }

    public HttpTarget(String protocol, String host, int port) {
        this(protocol, host, port, "/");
    }

    public HttpTarget(String protocol, String host, int port, String path) {
        this(protocol, host, port, path, false);
    }

    public HttpTarget(String protocol, String host, int port, String path, boolean insecure) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.path = path;
        this.insecure = insecure;
    }

    public HttpTarget(URL url) {
        this(url, false);
    }

    public HttpTarget(URL url, boolean insecure) {
        this(url.getProtocol() == null ? "http" : url.getProtocol(), url.getHost(), url.getPort() == -1 && url.getProtocol().equalsIgnoreCase("http") ? 8080 : (url.getPort() == -1 && url.getProtocol().equalsIgnoreCase("https") ? 443 : url.getPort()), url.getPath() == null ? "/" : url.getPath(), insecure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testInteraction(String consumerName, Interaction interaction, PactSource source) {
        ProviderInfo provider = this.getProviderInfo(source);
        ConsumerInfo consumer = new ConsumerInfo(consumerName);
        ProviderVerifier verifier = this.setupVerifier(interaction, provider, consumer);
        HashMap<String, Object> failures = new HashMap<String, Object>();
        ProviderClient client = new ProviderClient((IProviderInfo)provider, (IHttpClientFactory)new HttpClientFactory());
        verifier.verifyResponseFromProvider(provider, interaction, interaction.getDescription(), failures, client);
        this.reportTestResult(failures.isEmpty(), verifier);
        try {
            if (!failures.isEmpty()) {
                verifier.displayFailures(failures);
                throw this.getAssertionError(failures);
            }
        }
        finally {
            verifier.finialiseReports();
        }
    }

    @Override
    protected ProviderVerifier setupVerifier(Interaction interaction, ProviderInfo provider, ConsumerInfo consumer) {
        ProviderVerifier verifier = new ProviderVerifier();
        this.setupReporters(verifier, provider.getName(), interaction.getDescription());
        verifier.initialiseReporters(provider);
        verifier.reportVerificationForConsumer(consumer, provider);
        if (!interaction.getProviderStates().isEmpty()) {
            for (ProviderState providerState : interaction.getProviderStates()) {
                verifier.reportStateForInteraction(providerState.getName(), provider, consumer, true);
            }
        }
        verifier.reportInteractionDescription((Object)interaction);
        return verifier;
    }

    @Override
    protected ProviderInfo getProviderInfo(PactSource source) {
        List methods;
        Provider provider = (Provider)this.testClass.getAnnotation(Provider.class);
        ProviderInfo providerInfo = new ProviderInfo(provider.value());
        providerInfo.setPort((Object)this.port);
        providerInfo.setHost((Object)this.host);
        providerInfo.setProtocol(this.protocol);
        providerInfo.setPath(this.path);
        providerInfo.setInsecure(this.insecure);
        if (this.testClass != null && !(methods = this.testClass.getAnnotatedMethods(TargetRequestFilter.class)).isEmpty()) {
            providerInfo.setRequestFilter(httpRequest -> methods.forEach(method -> {
                try {
                    method.invokeExplosively(this.testTarget, new Object[]{httpRequest});
                }
                catch (Throwable t) {
                    throw new AssertionError("Request filter method " + method.getName() + " failed with an exception", t);
                }
            }));
        }
        return providerInfo;
    }
}

