/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.DirectorySource;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.provider.junit.loader.PactFolder;
import au.com.dius.pact.provider.junit.loader.PactFolderLoader;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lau/com/dius/pact/provider/junit/loader/PactFolderLoader;", "Lau/com/dius/pact/provider/junit/loader/PactLoader;", "path", "", "(Ljava/lang/String;)V", "Ljava/net/URL;", "(Ljava/net/URL;)V", "pactFolder", "Lau/com/dius/pact/provider/junit/loader/PactFolder;", "(Lau/com/dius/pact/provider/junit/loader/PactFolder;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "pactSource", "Lau/com/dius/pact/model/DirectorySource;", "getPactSource", "load", "", "Lau/com/dius/pact/model/Pact;", "providerName", "resolvePath", "pact-jvm-provider-junit_2.12"})
public final class PactFolderLoader
implements PactLoader {
    private final DirectorySource pactSource;
    private final File path;

    @Override
    @NotNull
    public List<Pact> load(@NotNull String providerName) {
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        List pacts = new ArrayList();
        File pactFolder = this.resolvePath();
        File[] files2 = pactFolder.listFiles(load.files.1.INSTANCE);
        if (files2 != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                Pact pact = PactReader.loadPact((Object)file);
                if (!Intrinsics.areEqual((Object)pact.getProvider().getName(), (Object)providerName)) continue;
                Pact pact2 = pact;
                Intrinsics.checkExpressionValueIsNotNull((Object)pact2, (String)"pact");
                pacts.add(pact2);
                Map map2 = this.pactSource.getPacts();
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                map2.put(file2, pact);
            }
        }
        return pacts;
    }

    @NotNull
    public DirectorySource getPactSource() {
        return this.pactSource;
    }

    private final File resolvePath() {
        URL resourcePath = PactFolderLoader.class.getClassLoader().getResource(this.path.getPath());
        if (resourcePath == null) {
            return this.path;
        }
        return new File(URLDecoder.decode(resourcePath.getPath(), "UTF-8"));
    }

    public PactFolderLoader(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        this.pactSource = new DirectorySource(this.path, null, 2, null);
    }

    public PactFolderLoader(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(new File(path));
    }

    @Deprecated(message="Use PactUrlLoader for URLs")
    public PactFolderLoader(@Nullable URL path) {
        String string = path == null ? "" : path.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (path == null) \"\" else path.path");
        this(string);
    }

    public PactFolderLoader(@NotNull PactFolder pactFolder) {
        Intrinsics.checkParameterIsNotNull((Object)pactFolder, (String)"pactFolder");
        this(pactFolder.value());
    }
}

