/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.provider.junit.Consumer;
import au.com.dius.pact.provider.junit.IgnoreNoPactsToVerify;
import au.com.dius.pact.provider.junit.InteractionRunner;
import au.com.dius.pact.provider.junit.Provider;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.loader.PactSource;
import groovy.json.JsonException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactRunner
extends ParentRunner<InteractionRunner> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactRunner.class);
    private final List<InteractionRunner> child;

    public PactRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        List<Pact> pacts;
        Provider providerInfo = clazz.getAnnotation(Provider.class);
        if (providerInfo == null) {
            throw new InitializationError("Provider name should be specified by using " + Provider.class.getName() + " annotation");
        }
        String serviceName = providerInfo.value();
        Consumer consumerInfo = clazz.getAnnotation(Consumer.class);
        String consumerName = consumerInfo != null ? consumerInfo.value() : null;
        TestClass testClass = new TestClass(clazz);
        this.child = new ArrayList<InteractionRunner>();
        PactLoader pactLoader = this.getPactSource(testClass);
        try {
            pacts = this.filterPacts(pactLoader.load(serviceName).stream().filter(p -> consumerName == null || p.getConsumer().getName().equals(consumerName)).collect(Collectors.toList()));
        }
        catch (JsonException | IOException e) {
            throw new InitializationError(e);
        }
        if (pacts == null || pacts.isEmpty()) {
            if (clazz.isAnnotationPresent(IgnoreNoPactsToVerify.class)) {
                LOGGER.warn("Did not find any pact files for provider " + providerInfo.value());
            } else {
                throw new InitializationError("Did not find any pact files for provider " + providerInfo.value());
            }
        }
        if (pacts != null) {
            for (Pact pact : pacts) {
                this.child.add(new InteractionRunner(testClass, pact, pactLoader.getPactSource()));
            }
        }
    }

    protected List<Pact> filterPacts(List<Pact> pacts) {
        return pacts;
    }

    protected List<InteractionRunner> getChildren() {
        return this.child;
    }

    protected Description describeChild(InteractionRunner child) {
        return child.getDescription();
    }

    protected void runChild(InteractionRunner interaction, RunNotifier notifier) {
        interaction.run(notifier);
    }

    protected PactLoader getPactSource(TestClass clazz) throws InitializationError {
        List pactLoaders;
        PactSource pactSource = (PactSource)clazz.getAnnotation(PactSource.class);
        if ((pactSource == null ? 0 : 1) + (pactLoaders = Arrays.stream(clazz.getAnnotations()).filter(annotation -> annotation.annotationType().getAnnotation(PactSource.class) != null).collect(Collectors.toList())).size() != 1) {
            throw new InitializationError("Exactly one pact source should be set");
        }
        try {
            if (pactSource != null) {
                Class<? extends PactLoader> pactLoaderClass = pactSource.value();
                try {
                    Constructor<? extends PactLoader> contructorWithClass = pactLoaderClass.getDeclaredConstructor(Class.class);
                    contructorWithClass.setAccessible(true);
                    return contructorWithClass.newInstance(clazz.getJavaClass());
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return pactLoaderClass.newInstance();
                }
            }
            Annotation annotation2 = (Annotation)pactLoaders.iterator().next();
            return annotation2.annotationType().getAnnotation(PactSource.class).value().getConstructor(annotation2.annotationType()).newInstance(annotation2);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating pact source", (Throwable)e);
            throw new InitializationError((Throwable)e);
        }
    }
}

