/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.loader;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.UrlsSource;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.provider.junit.loader.PactUrl;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactUrlLoader
implements PactLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PactUrlLoader.class);
    private final String[] urls;
    private final UrlsSource pactSource;

    public PactUrlLoader(String[] urls) {
        this.urls = urls;
        this.pactSource = new UrlsSource(Arrays.stream(urls).collect(Collectors.toList()));
    }

    public PactUrlLoader(PactUrl pactUrl) {
        this(pactUrl.urls());
    }

    @Override
    public List<Pact> load(String providerName) {
        return Arrays.stream(this.urls).map(url -> {
            Pact pact = PactReader.loadPact((Object)url);
            this.getPactSource().getPacts().put(url, pact);
            return pact;
        }).collect(Collectors.toList());
    }

    public UrlsSource getPactSource() {
        return this.pactSource;
    }
}

