/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit.target;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.model.ProviderState;
import au.com.dius.pact.model.RequestResponseInteraction;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.HttpClientFactory;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.junit.Provider;
import au.com.dius.pact.provider.junit.TargetRequestFilter;
import au.com.dius.pact.provider.junit.target.BaseTarget;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.HttpRequest;
import org.jetbrains.annotations.NotNull;
import org.junit.runners.model.FrameworkMethod;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB9\b\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0014J6\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010'0&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006("}, d2={"Lau/com/dius/pact/provider/junit/target/HttpTarget;", "Lau/com/dius/pact/provider/junit/target/BaseTarget;", "host", "", "port", "", "(Ljava/lang/String;I)V", "url", "Ljava/net/URL;", "insecure", "", "(Ljava/net/URL;Z)V", "protocol", "path", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Z)V", "getHost", "()Ljava/lang/String;", "getInsecure", "()Z", "getPath", "getPort", "()I", "getProtocol", "getProviderInfo", "Lau/com/dius/pact/provider/ProviderInfo;", "source", "Lau/com/dius/pact/model/PactSource;", "setupVerifier", "Lau/com/dius/pact/provider/IProviderVerifier;", "interaction", "Lau/com/dius/pact/model/Interaction;", "provider", "consumer", "Lau/com/dius/pact/provider/ConsumerInfo;", "testInteraction", "", "consumerName", "context", "", "", "pact-jvm-provider-junit_2.12"})
public class HttpTarget
extends BaseTarget {
    @NotNull
    private final String protocol;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String path;
    private final boolean insecure;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInteraction(@NotNull String consumerName, @NotNull Interaction interaction, @NotNull PactSource source, @NotNull Map<String, ? extends Object> context) {
        Intrinsics.checkParameterIsNotNull((Object)consumerName, (String)"consumerName");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        ProviderInfo provider = this.getProviderInfo(source);
        ConsumerInfo consumer = new ConsumerInfo(consumerName, null, false, null, null, null, null, 126, null);
        IProviderVerifier verifier = this.setupVerifier(interaction, provider, consumer);
        Map failures = new LinkedHashMap();
        ProviderClient client = new ProviderClient((IProviderInfo)provider, (IHttpClientFactory)new HttpClientFactory());
        verifier.verifyResponseFromProvider((IProviderInfo)provider, (RequestResponseInteraction)interaction, interaction.getDescription(), failures, client, context);
        this.reportTestResult(failures.isEmpty(), verifier);
        try {
            if (!failures.isEmpty()) {
                verifier.displayFailures(failures);
                throw (Throwable)((Object)this.getAssertionError(failures));
            }
        }
        finally {
            verifier.finaliseReports();
        }
    }

    @Override
    @NotNull
    protected IProviderVerifier setupVerifier(@NotNull Interaction interaction, @NotNull ProviderInfo provider, @NotNull ConsumerInfo consumer) {
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        ProviderVerifier verifier = new ProviderVerifier();
        IProviderVerifier iProviderVerifier = (IProviderVerifier)verifier;
        String string = provider.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"provider.name");
        this.setupReporters(iProviderVerifier, string, interaction.getDescription());
        verifier.initialiseReporters(provider);
        verifier.reportVerificationForConsumer(consumer, provider);
        if (!interaction.getProviderStates().isEmpty()) {
            for (ProviderState providerState : interaction.getProviderStates()) {
                String name = providerState.component1();
                verifier.reportStateForInteraction(name, (IProviderInfo)provider, (IConsumerInfo)consumer, true);
            }
        }
        verifier.reportInteractionDescription((Object)interaction);
        return (IProviderVerifier)verifier;
    }

    @Override
    @NotNull
    protected ProviderInfo getProviderInfo(@NotNull PactSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Provider provider = (Provider)this.getTestClass().getAnnotation(Provider.class);
        ProviderInfo providerInfo = new ProviderInfo(provider.value());
        providerInfo.setPort((Object)this.getPort());
        providerInfo.setHost((Object)this.host);
        providerInfo.setProtocol(this.protocol);
        providerInfo.setPath(this.path);
        providerInfo.setInsecure(this.insecure);
        List methods = this.getTestClass().getAnnotatedMethods(TargetRequestFilter.class);
        if (!methods.isEmpty()) {
            providerInfo.setRequestFilter(new Consumer<HttpRequest>(this, methods){
                final /* synthetic */ HttpTarget this$0;
                final /* synthetic */ List $methods;

                public final void accept(@NotNull HttpRequest httpRequest) {
                    Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
                    List list = this.$methods;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"methods");
                    Iterable $receiver$iv = list;
                    for (T element$iv : $receiver$iv) {
                        FrameworkMethod method = (FrameworkMethod)element$iv;
                        try {
                            method.invokeExplosively(this.this$0.getTestTarget(), new Object[]{httpRequest});
                        }
                        catch (Throwable t) {
                            StringBuilder stringBuilder = new StringBuilder().append("Request filter method ");
                            FrameworkMethod frameworkMethod = method;
                            Intrinsics.checkExpressionValueIsNotNull((Object)frameworkMethod, (String)"method");
                            throw (Throwable)((Object)new AssertionError(stringBuilder.append(frameworkMethod.getName()).append(" failed with an exception").toString(), t));
                        }
                    }
                }
                {
                    this.this$0 = httpTarget;
                    this.$methods = list;
                }
            });
        }
        return providerInfo;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final boolean getInsecure() {
        return this.insecure;
    }

    @JvmOverloads
    public HttpTarget(@NotNull String protocol, @NotNull String host, int port, @NotNull String path, boolean insecure) {
        Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.insecure = insecure;
    }

    @JvmOverloads
    public /* synthetic */ HttpTarget(String string, String string2, int n, String string3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "http";
        }
        if ((n2 & 2) != 0) {
            string2 = "127.0.0.1";
        }
        if ((n2 & 4) != 0) {
            n = 8080;
        }
        if ((n2 & 8) != 0) {
            string3 = "/";
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(string, string2, n, string3, bl);
    }

    @JvmOverloads
    public HttpTarget(@NotNull String protocol, @NotNull String host, int port, @NotNull String path) {
        this(protocol, host, port, path, false, 16, null);
    }

    @JvmOverloads
    public HttpTarget(@NotNull String protocol, @NotNull String host, int port) {
        this(protocol, host, port, null, false, 24, null);
    }

    @JvmOverloads
    public HttpTarget(@NotNull String protocol, @NotNull String host) {
        this(protocol, host, 0, null, false, 28, null);
    }

    @JvmOverloads
    public HttpTarget(@NotNull String protocol) {
        this(protocol, null, 0, null, false, 30, null);
    }

    @JvmOverloads
    public HttpTarget() {
        this(null, null, 0, null, false, 31, null);
    }

    @JvmOverloads
    public HttpTarget(@NotNull String host, int port) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this("http", host, port, null, false, 24, null);
    }

    @JvmOverloads
    public /* synthetic */ HttpTarget(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "127.0.0.1";
        }
        this(string, n);
    }

    @JvmOverloads
    public HttpTarget(int port) {
        this(null, port, 1, null);
    }

    @JvmOverloads
    public HttpTarget(@NotNull URL url, boolean insecure) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String string = url.getProtocol() == null ? "http" : url.getProtocol();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (url.protocol == null) \"http\" else url.protocol");
        String string2 = url.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.host");
        int n = url.getPort() == -1 && StringsKt.equals((String)url.getProtocol(), (String)"http", (boolean)true) ? 8080 : (url.getPort() == -1 && StringsKt.equals((String)url.getProtocol(), (String)"https", (boolean)true) ? 443 : url.getPort());
        String string3 = url.getPath() == null ? "/" : url.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"if (url.path == null) \"/\" else url.path");
        this(string, string2, n, string3, insecure);
    }

    @JvmOverloads
    public /* synthetic */ HttpTarget(URL uRL, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(uRL, bl);
    }

    @JvmOverloads
    public HttpTarget(@NotNull URL url) {
        this(url, false, 2, null);
    }
}

