/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.maven;

import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.provider.maven.PactPublishMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.fusesource.jansi.AnsiConsole;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\t8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\t8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\t8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lau/com/dius/pact/provider/maven/PactPublishMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "brokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "decrypter", "Lorg/apache/maven/settings/crypto/SettingsDecrypter;", "excludes", "", "", "pactBrokerAuthenticationScheme", "pactBrokerPassword", "pactBrokerServerId", "pactBrokerToken", "pactBrokerUrl", "pactBrokerUsername", "pactDirectory", "projectVersion", "settings", "Lorg/apache/maven/settings/Settings;", "tags", "trimSnapshot", "", "execute", "", "pactFileIsExcluded", "exclusions", "", "Lkotlin/text/Regex;", "pactFile", "Ljava/io/File;", "pact-jvm-provider-maven"})
@Mojo(name="publish")
public class PactPublishMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.version}")
    private String projectVersion;
    @Parameter(defaultValue="false")
    private boolean trimSnapshot;
    @Parameter(defaultValue="${project.build.directory}/pacts")
    private String pactDirectory;
    @Parameter(required=true)
    private String pactBrokerUrl;
    @Parameter
    private String pactBrokerServerId;
    @Parameter
    private String pactBrokerToken;
    @Parameter
    private String pactBrokerUsername;
    @Parameter
    private String pactBrokerPassword;
    @Parameter(defaultValue="basic")
    private String pactBrokerAuthenticationScheme;
    private PactBrokerClient brokerClient;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;
    @Parameter
    private List<String> tags;
    @Parameter
    private List<String> excludes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() {
        File pactDirectory;
        String serverDetails;
        AnsiConsole.systemInstall();
        String snapShotDefinitionString = "-SNAPSHOT";
        String emptyString = "";
        if (this.trimSnapshot) {
            String string = this.projectVersion;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
            }
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)snapShotDefinitionString, (boolean)false, (int)2, null)) {
                String string2 = this.projectVersion;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                this.projectVersion = StringsKt.replaceFirst$default((String)string2, (String)snapShotDefinitionString, (String)emptyString, (boolean)false, (int)4, null);
            }
        }
        if (this.brokerClient == null) {
            boolean bl = false;
            Map options = new LinkedHashMap();
            CharSequence charSequence = this.pactBrokerToken;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                this.pactBrokerAuthenticationScheme = "bearer";
                options.put("authentication", CollectionsKt.listOf((Object[])new String[]{this.pactBrokerAuthenticationScheme, this.pactBrokerToken}));
            } else {
                charSequence = this.pactBrokerUsername;
                bl2 = false;
                bl3 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    Object[] objectArray = new String[3];
                    String string = this.pactBrokerAuthenticationScheme;
                    if (string == null) {
                        string = "basic";
                    }
                    objectArray[0] = string;
                    objectArray[1] = this.pactBrokerUsername;
                    objectArray[2] = this.pactBrokerPassword;
                    options.put("authentication", CollectionsKt.listOf((Object[])objectArray));
                } else {
                    charSequence = this.pactBrokerServerId;
                    bl2 = false;
                    bl3 = false;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        Settings settings = this.settings;
                        if (settings == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                        }
                        serverDetails = settings.getServer(this.pactBrokerServerId);
                        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest((Server)serverDetails);
                        SettingsDecrypter settingsDecrypter = this.decrypter;
                        if (settingsDecrypter == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"decrypter");
                        }
                        SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
                        Object[] objectArray = new String[3];
                        String string = this.pactBrokerAuthenticationScheme;
                        if (string == null) {
                            string = "basic";
                        }
                        objectArray[0] = string;
                        String string3 = serverDetails;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"serverDetails");
                        objectArray[1] = string3.getUsername();
                        SettingsDecryptionResult settingsDecryptionResult = result;
                        Intrinsics.checkExpressionValueIsNotNull((Object)settingsDecryptionResult, (String)"result");
                        Server server = settingsDecryptionResult.getServer();
                        Intrinsics.checkExpressionValueIsNotNull((Object)server, (String)"result.server");
                        objectArray[2] = server.getPassword();
                        options.put("authentication", CollectionsKt.listOf((Object[])objectArray));
                    }
                }
            }
            String string = this.pactBrokerUrl;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pactBrokerUrl");
            }
            this.brokerClient = new PactBrokerClient(string, options);
        }
        String string = this.pactDirectory;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pactDirectory");
        }
        if (!(pactDirectory = new File(string)).exists()) {
            serverDetails = "Pact directory " + pactDirectory + " does not exist, skipping uploading of pacts";
            boolean request = false;
            System.out.println((Object)serverDetails);
        } else {
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.excludes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Regex regex = new Regex(it);
                collection.add(regex);
            }
            List excludedList = (List)destination$iv$iv;
            try {
                boolean anyFailed = false;
                Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)pactDirectory)), (Function1)execute.1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean bl;
                    File pactFile = (File)element$iv;
                    boolean bl4 = false;
                    if (this.pactFileIsExcluded(excludedList, pactFile)) {
                        it = "Not publishing '" + pactFile.getName() + "' as it matches an item in the excluded list";
                        bl = false;
                        System.out.println((Object)it);
                        continue;
                    }
                    it = "Publishing '" + pactFile.getName() + "' ... ";
                    bl = false;
                    System.out.print((Object)it);
                    PactBrokerClient pactBrokerClient = this.brokerClient;
                    if (pactBrokerClient == null) {
                        Intrinsics.throwNpe();
                    }
                    String string5 = this.projectVersion;
                    if (string5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                    }
                    String result = String.valueOf(pactBrokerClient.uploadPactFile(pactFile, string5, this.tags));
                    bl = false;
                    System.out.println((Object)result);
                    if (anyFailed || !StringsKt.startsWith$default((String)result, (String)"FAILED!", (boolean)false, (int)2, null)) continue;
                    anyFailed = true;
                }
                if (anyFailed) {
                    throw (Throwable)new MojoExecutionException("One or more of the pact files were rejected by the pact broker");
                }
            }
            finally {
                AnsiConsole.systemUninstall();
            }
        }
    }

    private final boolean pactFileIsExcluded(List<Regex> exclusions, File pactFile) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)FilesKt.getNameWithoutExtension((File)pactFile))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public PactPublishMojo() {
        List list;
        PactPublishMojo pactPublishMojo = this;
        boolean bl = false;
        pactPublishMojo.tags = list = (List)new ArrayList();
        pactPublishMojo = this;
        bl = false;
        pactPublishMojo.excludes = list = (List)new ArrayList();
    }
}

