/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.maven;

import au.com.dius.pact.provider.broker.PactBrokerClient;
import au.com.dius.pact.provider.maven.PactPublishMojo;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.fusesource.jansi.AnsiConsole;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00108\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lau/com/dius/pact/provider/maven/PactPublishMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "brokerClient", "Lau/com/dius/pact/provider/broker/PactBrokerClient;", "decrypter", "Lorg/apache/maven/settings/crypto/SettingsDecrypter;", "pactBrokerAuthenticationScheme", "", "pactBrokerPassword", "pactBrokerServerId", "pactBrokerUrl", "pactBrokerUsername", "pactDirectory", "projectVersion", "settings", "Lorg/apache/maven/settings/Settings;", "trimSnapshot", "", "execute", "", "pact-jvm-provider-maven_2.12"})
@Mojo(name="publish")
public class PactPublishMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.version}")
    private String projectVersion;
    @Parameter(defaultValue="false")
    private boolean trimSnapshot;
    @Parameter(defaultValue="${project.build.directory}/pacts")
    private String pactDirectory;
    @Parameter(required=true)
    private String pactBrokerUrl;
    @Parameter
    private String pactBrokerServerId;
    @Parameter
    private String pactBrokerUsername;
    @Parameter
    private String pactBrokerPassword;
    @Parameter(defaultValue="basic")
    private String pactBrokerAuthenticationScheme;
    private PactBrokerClient brokerClient;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        File pactDirectory;
        Object object;
        AnsiConsole.systemInstall();
        if (this.trimSnapshot) {
            String string = this.projectVersion;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
            }
            if (StringsKt.endsWith$default((String)string, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) {
                String string2;
                String string3 = this.projectVersion;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                String string4 = string3;
                int n = 0;
                String string5 = this.projectVersion;
                if (string5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                int n2 = string5.length() - 9;
                PactPublishMojo pactPublishMojo = this;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                pactPublishMojo.projectVersion = string2 = string7;
            }
        }
        if (this.brokerClient == null) {
            Map options = new LinkedHashMap();
            Object object2 = this.pactBrokerUsername;
            if (!(object2 == null || object2.length() == 0)) {
                object2 = options;
                String string = "authentication";
                Object[] objectArray = new String[3];
                String string8 = this.pactBrokerAuthenticationScheme;
                if (string8 == null) {
                    string8 = "basic";
                }
                objectArray[0] = string8;
                objectArray[1] = this.pactBrokerUsername;
                objectArray[2] = this.pactBrokerPassword;
                List list = CollectionsKt.listOf((Object[])objectArray);
                object2.put(string, list);
            } else {
                object2 = this.pactBrokerServerId;
                if (!(object2 == null || object2.length() == 0)) {
                    Settings settings = this.settings;
                    if (settings == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    }
                    Server serverDetails = settings.getServer(this.pactBrokerServerId);
                    DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(serverDetails);
                    SettingsDecrypter settingsDecrypter = this.decrypter;
                    if (settingsDecrypter == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"decrypter");
                    }
                    SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
                    Map map = options;
                    String string = "authentication";
                    Object[] objectArray = new String[3];
                    String string9 = this.pactBrokerAuthenticationScheme;
                    if (string9 == null) {
                        string9 = "basic";
                    }
                    objectArray[0] = string9;
                    objectArray[1] = serverDetails.getUsername();
                    objectArray[2] = result.getServer().getPassword();
                    object = CollectionsKt.listOf((Object[])objectArray);
                    map.put(string, object);
                }
            }
            String string = this.pactBrokerUrl;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pactBrokerUrl");
            }
            this.brokerClient = new PactBrokerClient(string, options);
        }
        String string = this.pactDirectory;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pactDirectory");
        }
        if (!(pactDirectory = new File(string)).exists()) {
            String serverDetails = "Pact directory " + pactDirectory + " does not exist, skipping uploading of pacts";
            System.out.println((Object)serverDetails);
        } else {
            try {
                boolean anyFailed = false;
                Sequence $receiver$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)pactDirectory)), (Function1)execute.1.INSTANCE);
                for (Object element$iv : $receiver$iv) {
                    File pactFile = (File)element$iv;
                    object = "Publishing " + pactFile.getName() + " ... ";
                    System.out.print(object);
                    PactBrokerClient pactBrokerClient = this.brokerClient;
                    if (pactBrokerClient == null) {
                        Intrinsics.throwNpe();
                    }
                    String string10 = this.projectVersion;
                    if (string10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                    }
                    String result = pactBrokerClient.uploadPactFile(pactFile, string10).toString();
                    System.out.println((Object)result);
                    if (anyFailed || !StringsKt.startsWith$default((String)result, (String)"FAILED!", (boolean)false, (int)2, null)) continue;
                    anyFailed = true;
                }
                if (anyFailed) {
                    throw (Throwable)new MojoExecutionException("One or more of the pact files were rejected by the pact broker");
                }
            }
            finally {
                AnsiConsole.systemUninstall();
            }
        }
    }
}

