/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.provider.DefaultTestResultAccumulator;
import au.com.dius.pact.provider.DefaultVerificationReporter;
import au.com.dius.pact.provider.TestResultAccumulator;
import au.com.dius.pact.provider.VerificationReporter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0014J\u0016\u0010\u0018\u001a\u00020\u00062\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013J\u0018\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001cJ(\u0010\u001e\u001a\u00020\u001a2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J(\u0010\u001e\u001a\u00020\u001a2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0011H\u0016R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lau/com/dius/pact/provider/DefaultTestResultAccumulator;", "Lau/com/dius/pact/provider/TestResultAccumulator;", "Lmu/KLogging;", "()V", "testResults", "", "", "Lau/com/dius/pact/core/pactbroker/TestResult;", "getTestResults", "()Ljava/util/Map;", "verificationReporter", "Lau/com/dius/pact/provider/VerificationReporter;", "getVerificationReporter", "()Lau/com/dius/pact/provider/VerificationReporter;", "setVerificationReporter", "(Lau/com/dius/pact/provider/VerificationReporter;)V", "allInteractionsVerified", "", "pact", "Lau/com/dius/pact/core/model/Pact;", "Lau/com/dius/pact/core/model/Interaction;", "results", "calculateInteractionHash", "interaction", "calculatePactHash", "clearTestResult", "", "lookupProviderTag", "", "lookupProviderVersion", "updateTestResult", "testExecutionResult", "pact-jvm-provider"})
public final class DefaultTestResultAccumulator
extends KLogging
implements TestResultAccumulator {
    @NotNull
    private static final Map<Integer, Map<Integer, TestResult>> testResults;
    @NotNull
    private static VerificationReporter verificationReporter;
    public static final DefaultTestResultAccumulator INSTANCE;

    @NotNull
    public final Map<Integer, Map<Integer, TestResult>> getTestResults() {
        return testResults;
    }

    @NotNull
    public final VerificationReporter getVerificationReporter() {
        return verificationReporter;
    }

    public final void setVerificationReporter(@NotNull VerificationReporter verificationReporter) {
        Intrinsics.checkParameterIsNotNull((Object)verificationReporter, (String)"<set-?>");
        DefaultTestResultAccumulator.verificationReporter = verificationReporter;
    }

    @Override
    public void updateTestResult(@NotNull Pact<? extends Interaction> pact2, @NotNull Interaction interaction, boolean testExecutionResult) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        this.updateTestResult(pact2, interaction, TestResult.Companion.fromBoolean(testExecutionResult));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateTestResult(@NotNull Pact<? extends Interaction> pact2, @NotNull Interaction interaction, @NotNull TestResult testExecutionResult) {
        int interactionHash;
        Map interactionResults;
        TestResult testResult;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull((Object)testExecutionResult, (String)"testExecutionResult");
        this.getLogger().debug((Function0)new Function0<String>(testExecutionResult, pact2, interaction){
            final /* synthetic */ TestResult $testExecutionResult;
            final /* synthetic */ Pact $pact;
            final /* synthetic */ Interaction $interaction;

            @NotNull
            public final String invoke() {
                return "Received test result '" + this.$testExecutionResult + "' for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + ' ' + "and " + this.$interaction.getDescription();
            }
            {
                this.$testExecutionResult = testResult;
                this.$pact = pact2;
                this.$interaction = interaction;
                super(0);
            }
        });
        int pactHash = this.calculatePactHash(pact2);
        Map<Integer, Map<Integer, TestResult>> map = testResults;
        Integer key$iv = pactHash;
        boolean $i$f$getOrPut2 = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((testResult = (TestResult)(interactionResults = (Map)object).get(interactionHash = this.calculateInteractionHash(interaction))) == null) {
            interactionResults.put(interactionHash, testExecutionResult);
        } else {
            interactionResults.put(interactionHash, testResult.merge(testExecutionResult));
        }
        if (this.allInteractionsVerified(pact2, interactionResults)) {
            this.getLogger().debug((Function0)new Function0<String>(pact2){
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "All interactions for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + " have a verification result";
                }
                {
                    this.$pact = pact2;
                    super(0);
                }
            });
            if (verificationReporter.publishingResultsDisabled()) {
                this.getLogger().warn((Function0)updateTestResult.3.INSTANCE);
            } else {
                void $this$fold$iv;
                void initial$iv;
                Iterable $i$f$getOrPut2 = interactionResults.values();
                value$iv = TestResult.Ok.INSTANCE;
                Pact<? extends Interaction> pact3 = pact2;
                VerificationReporter verificationReporter = DefaultTestResultAccumulator.verificationReporter;
                boolean $i$f$fold = false;
                TestResult accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void result2;
                    TestResult testResult2 = (TestResult)element$iv;
                    TestResult acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc.merge((TestResult)result2);
                }
                void var19_24 = accumulator$iv;
                verificationReporter.reportResults(pact3, (TestResult)var19_24, this.lookupProviderVersion(), null, this.lookupProviderTag());
            }
            testResults.remove(pactHash);
        } else {
            this.getLogger().info((Function0)new Function0<String>(pact2){
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "Not all of the " + this.$pact.getInteractions().size() + " were verified.";
                }
                {
                    this.$pact = pact2;
                    super(0);
                }
            });
        }
    }

    public final int calculateInteractionHash(@NotNull Interaction interaction) {
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)interaction.getDescription());
        Iterable $this$forEach$iv = interaction.getProviderStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProviderState it = (ProviderState)element$iv;
            boolean bl = false;
            builder.append((Object)it.getName());
        }
        return builder.toHashCode();
    }

    public final int calculatePactHash(@NotNull Pact<? extends Interaction> pact2) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        return new HashCodeBuilder().append((Object)pact2.getConsumer().getName()).append((Object)pact2.getProvider().getName()).toHashCode();
    }

    @NotNull
    public final String lookupProviderVersion() {
        String string;
        String version = System.getProperty("pact.provider.version");
        CharSequence charSequence = version;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.getLogger().warn((Function0)lookupProviderVersion.1.INSTANCE);
            string = "0.0.0";
        } else {
            string = version;
        }
        return string;
    }

    private final String lookupProviderTag() {
        return System.getProperty("pact.provider.tag");
    }

    public final boolean allInteractionsVerified(@NotNull Pact<? extends Interaction> pact2, @NotNull Map<Integer, TestResult> results) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            this.getLogger().debug((Function0)new Function0<String>(pact2, results){
                final /* synthetic */ Pact $pact;
                final /* synthetic */ Map $results;

                @NotNull
                public final String invoke() {
                    return "Number of interactions #" + this.$pact.getInteractions().size() + " and results: " + this.$results.values();
                }
                {
                    this.$pact = pact2;
                    this.$results = map;
                    super(0);
                }
            });
            Iterable $this$all$iv = pact2.getInteractions();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Interaction it = (Interaction)element$iv;
                    boolean bl2 = false;
                    if (results.containsKey(INSTANCE.calculateInteractionHash(it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void clearTestResult(@NotNull Pact<? extends Interaction> pact2) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        int pactHash = this.calculatePactHash(pact2);
        testResults.remove(pactHash);
    }

    private DefaultTestResultAccumulator() {
    }

    static {
        DefaultTestResultAccumulator defaultTestResultAccumulator;
        INSTANCE = defaultTestResultAccumulator = new DefaultTestResultAccumulator();
        boolean bl = false;
        testResults = new LinkedHashMap();
        verificationReporter = DefaultVerificationReporter.INSTANCE;
    }
}

