/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.provider.VerificationReporter;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Result;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003JP\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J<\u0010\u0016\u001a\u00020\u00052\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0016J@\u0010\u0016\u001a\u00020\u00052\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016\u00a8\u0006\u0019"}, d2={"Lau/com/dius/pact/provider/DefaultVerificationReporter;", "Lau/com/dius/pact/provider/VerificationReporter;", "Lmu/KLogging;", "()V", "publishResult", "", "I", "Lau/com/dius/pact/core/model/Interaction;", "brokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "source", "Lau/com/dius/pact/core/model/BrokerUrlSource;", "result", "Lau/com/dius/pact/core/pactbroker/TestResult;", "version", "", "pact", "Lau/com/dius/pact/core/model/Pact;", "tags", "", "publishingResultsDisabled", "", "reportResults", "client", "tag", "provider"})
public final class DefaultVerificationReporter
extends KLogging
implements VerificationReporter {
    public static final DefaultVerificationReporter INSTANCE;

    @Override
    public void reportResults(@NotNull Pact<? extends Interaction> pact2, @NotNull TestResult result2, @NotNull String version2, @Nullable PactBrokerClient client, @Nullable String tag) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        CharSequence charSequence = tag;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.reportResults(pact2, result2, version2, client, CollectionsKt.emptyList());
        } else {
            this.reportResults(pact2, result2, version2, client, CollectionsKt.listOf((Object)tag));
        }
    }

    @Override
    public void reportResults(@NotNull Pact<? extends Interaction> pact2, @NotNull TestResult result2, @NotNull String version2, @Nullable PactBrokerClient client, @NotNull List<String> tags) {
        Intrinsics.checkParameterIsNotNull(pact2, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        PactSource source = pact2.getSource();
        if (source instanceof BrokerUrlSource) {
            PactBrokerClient pactBrokerClient = client;
            if (pactBrokerClient == null) {
                pactBrokerClient = new PactBrokerClient(((BrokerUrlSource)source).getPactBrokerUrl(), ((BrokerUrlSource)source).getOptions());
            }
            PactBrokerClient brokerClient = pactBrokerClient;
            this.publishResult(brokerClient, (BrokerUrlSource)source, result2, version2, pact2, tags);
        } else {
            this.getLogger().info((Function0)new Function0<String>(source){
                final /* synthetic */ PactSource $source;

                @NotNull
                public final String invoke() {
                    return "Skipping publishing verification results for source " + this.$source;
                }
                {
                    this.$source = pactSource;
                    super(0);
                }
            });
        }
    }

    private final <I extends Interaction> void publishResult(PactBrokerClient brokerClient, BrokerUrlSource source, TestResult result2, String version2, Pact<? extends I> pact2, List<String> tags) {
        Result publishResult2;
        Collection collection = tags;
        boolean bl = false;
        if (!collection.isEmpty()) {
            brokerClient.publishProviderTags(source.getAttributes(), pact2.getProvider().getName(), tags, version2);
        }
        if ((publishResult2 = PactBrokerClient.publishVerificationResults$default((PactBrokerClient)brokerClient, (Map)source.getAttributes(), (TestResult)result2, (String)version2, null, (int)8, null)) instanceof Err) {
            this.getLogger().error((Function0)new Function0<String>(publishResult2){
                final /* synthetic */ Result $publishResult;

                @NotNull
                public final String invoke() {
                    return "Failed to publish verification results - " + (String)((Err)this.$publishResult).getError();
                }
                {
                    this.$publishResult = result2;
                    super(0);
                }
            });
        } else {
            this.getLogger().info((Function0)new Function0<String>(result2, pact2){
                final /* synthetic */ TestResult $result;
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "Published verification result of '" + this.$result + "' for consumer '" + this.$pact.getConsumer() + '\'';
                }
                {
                    this.$result = testResult;
                    this.$pact = pact2;
                    super(0);
                }
            });
        }
    }

    @Override
    public boolean publishingResultsDisabled() {
        String string;
        String property = System.getProperty("pact.verifier.publishResults");
        CharSequence charSequence = property;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            property = System.getenv("pact.verifier.publishResults");
        }
        String string2 = property;
        if (string2 != null) {
            charSequence = string2;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)charSequence2).toLowerCase();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return Intrinsics.areEqual(string, (Object)"true") ^ true;
    }

    private DefaultVerificationReporter() {
    }

    static {
        DefaultVerificationReporter defaultVerificationReporter;
        INSTANCE = defaultVerificationReporter = new DefaultVerificationReporter();
    }
}

