/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.ECUtil;

public class JCEECDHKeyAgreement
extends KeyAgreementSpi {
    private static final Hashtable algorithms = new Hashtable();
    private BigInteger result;
    private CipherParameters privKey;
    private BasicAgreement agreement;
    private DerivationFunction kdf;

    private byte[] bigIntToBytes(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    protected JCEECDHKeyAgreement(BasicAgreement basicAgreement) {
        this.agreement = basicAgreement;
    }

    protected JCEECDHKeyAgreement(BasicAgreement basicAgreement, DerivationFunction derivationFunction) {
        this.agreement = basicAgreement;
        this.kdf = derivationFunction;
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("EC Diffie-Hellman not initialised.");
        }
        if (!bl) {
            throw new IllegalStateException("EC Diffie-Hellman can only be between two parties.");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("EC Key Agreement doPhase requires ECPublicKey");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = ECUtil.generatePublicKeyParameter((PublicKey)key);
        this.result = this.agreement.calculateAgreement(asymmetricKeyParameter);
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.bigIntToBytes(this.result);
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.bigIntToBytes(this.result);
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException("ECKeyAgreement - buffer too short");
        }
        if (this.kdf != null) {
            this.kdf.init(new KDFParameters(byArray2, null));
            this.kdf.generateBytes(byArray, n, byArray.length - n);
        } else {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) {
        if (algorithms.containsKey(string)) {
            int n = (Integer)algorithms.get(string);
            byte[] byArray = new byte[n / 8];
            if (this.kdf != null) {
                this.kdf.init(new KDFParameters(this.bigIntToBytes(this.result), null));
                this.kdf.generateBytes(byArray, 0, byArray.length);
            } else {
                System.arraycopy(this.bigIntToBytes(this.result), 0, byArray, 0, byArray.length);
            }
            return new SecretKeySpec(byArray, string);
        }
        return new SecretKeySpec(this.bigIntToBytes(this.result), string);
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey for initialisation");
        }
        this.privKey = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey");
        }
        this.privKey = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    static {
        Integer n = new Integer(128);
        Integer n2 = new Integer(192);
        Integer n3 = new Integer(256);
        algorithms.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), n);
        algorithms.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), n2);
        algorithms.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), n3);
        algorithms.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), n);
        algorithms.put(NISTObjectIdentifiers.id_aes192_wrap.getId(), n2);
        algorithms.put(NISTObjectIdentifiers.id_aes256_wrap.getId(), n3);
    }

    public static class DHwithSHA1KDF
    extends JCEECDHKeyAgreement {
        public DHwithSHA1KDF() {
            super(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()));
        }
    }

    public static class DHC
    extends JCEECDHKeyAgreement {
        public DHC() {
            super(new ECDHCBasicAgreement());
        }
    }

    public static class DH
    extends JCEECDHKeyAgreement {
        public DH() {
            super(new ECDHBasicAgreement());
        }
    }
}

