/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.LinkImpl;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.services.BaseURLSource;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ContextPathEncoder;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.URLRewriter;
import org.apache.tapestry5.urlrewriter.SimpleRequestWrapper;
import org.apache.tapestry5.urlrewriter.URLRewriteContext;

public class ComponentEventLinkEncoderMethodAdvice
implements MethodAdvice {
    private final URLRewriter urlRewriter;
    private final Request request;
    private final HttpServletRequest httpServletRequest;
    private final Response response;
    private final boolean forPageLink;
    private final ContextPathEncoder contextPathEncoder;
    private final BaseURLSource baseURLSource;
    private static final int CONTEXT_PARAMETER_INDEX = 0;

    public ComponentEventLinkEncoderMethodAdvice(URLRewriter urlRewriter, Request request, HttpServletRequest httpServletRequest, Response response, boolean forPageLink, ContextPathEncoder contextPathEncoder, BaseURLSource baseURLSource) {
        assert (urlRewriter != null);
        assert (request != null);
        assert (httpServletRequest != null);
        assert (response != null);
        assert (contextPathEncoder != null);
        assert (baseURLSource != null);
        this.httpServletRequest = httpServletRequest;
        this.urlRewriter = urlRewriter;
        this.request = request;
        this.response = response;
        this.forPageLink = forPageLink;
        this.contextPathEncoder = contextPathEncoder;
        this.baseURLSource = baseURLSource;
    }

    public void advise(MethodInvocation invocation) {
        invocation.proceed();
        Link link = (Link)invocation.getReturnValue();
        URLRewriteContext context = this.setupContext(invocation);
        Link newLink = this.rewriteIfNeeded(link, context);
        if (newLink != null) {
            invocation.setReturnValue((Object)newLink);
        }
    }

    private URLRewriteContext setupContext(final MethodInvocation invocation) {
        if (this.forPageLink) {
            return new URLRewriteContext(){

                public boolean isIncoming() {
                    return false;
                }

                public PageRenderRequestParameters getPageParameters() {
                    return (PageRenderRequestParameters)invocation.getParameter(0);
                }

                public ComponentEventRequestParameters getComponentEventParameters() {
                    return null;
                }
            };
        }
        return new URLRewriteContext(){

            public boolean isIncoming() {
                return false;
            }

            public PageRenderRequestParameters getPageParameters() {
                return null;
            }

            public ComponentEventRequestParameters getComponentEventParameters() {
                return (ComponentEventRequestParameters)invocation.getParameter(0);
            }
        };
    }

    Link rewriteIfNeeded(Link link, URLRewriteContext context) {
        Request rewritten;
        LinkImpl newLink = null;
        SimpleRequestWrapper fakeRequest = new SimpleRequestWrapper(this.request, link.toURI());
        if (fakeRequest != (rewritten = this.urlRewriter.processLink(fakeRequest, context))) {
            String rewrittenServerName;
            String originalServerName = this.request.getServerName();
            boolean absolute = !originalServerName.equals(rewrittenServerName = rewritten.getServerName());
            String newPath = rewritten.getPath();
            String newUrl = absolute ? this.fullUrl(rewritten) : newPath;
            newLink = new LinkImpl(newUrl, false, link.getSecurity(), this.response, this.contextPathEncoder, this.baseURLSource);
        }
        return newLink;
    }

    String fullUrl(Request request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int localPort = this.httpServletRequest.getLocalPort();
        String port = localPort == 80 ? "" : ":" + localPort;
        String path = request.getPath();
        String contextPath = request.getContextPath();
        return String.format("%s%s%s%s%s", protocol, request.getServerName(), port, contextPath, path);
    }
}

