/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.ioc.annotations.UsesOrderedConfiguration;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.URLRewriter;
import org.apache.tapestry5.urlrewriter.URLRewriteContext;
import org.apache.tapestry5.urlrewriter.URLRewriterRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsesOrderedConfiguration(value=URLRewriterRule.class)
public class URLRewriterImpl
implements URLRewriter {
    private static final String URL_REWRITER_RULE_PROCESS_MUST_NOT_RETURN_NULL = "URLRewriterRule.process() must not return null";
    private final List<URLRewriterRule> incomingRules;
    private final List<URLRewriterRule> outgoingRules;

    public URLRewriterImpl(List<URLRewriterRule> rules) {
        assert (rules != null);
        this.incomingRules = new ArrayList<URLRewriterRule>();
        this.outgoingRules = new ArrayList<URLRewriterRule>();
        block4: for (URLRewriterRule rule : rules) {
            switch (rule.applicability()) {
                case INBOUND: {
                    this.incomingRules.add(rule);
                    continue block4;
                }
                case OUTBOUND: {
                    this.outgoingRules.add(rule);
                    continue block4;
                }
            }
            this.incomingRules.add(rule);
            this.outgoingRules.add(rule);
        }
    }

    @Override
    public Request processRequest(Request request) {
        if ((request = this.process(request, this.incomingRules, new URLRewriteContext(){

            public boolean isIncoming() {
                return true;
            }

            public PageRenderRequestParameters getPageParameters() {
                return null;
            }

            public ComponentEventRequestParameters getComponentEventParameters() {
                return null;
            }
        })) == null) {
            throw new NullPointerException(URL_REWRITER_RULE_PROCESS_MUST_NOT_RETURN_NULL);
        }
        return request;
    }

    private Request process(Request request, List<URLRewriterRule> rules, URLRewriteContext context) {
        for (URLRewriterRule rule : rules) {
            request = rule.process(request, context);
            if (request != null) continue;
            return null;
        }
        return request;
    }

    @Override
    public Request processLink(Request request, URLRewriteContext context) {
        if ((request = this.process(request, this.outgoingRules, context)) == null) {
            throw new NullPointerException(URL_REWRITER_RULE_PROCESS_MUST_NOT_RETURN_NULL);
        }
        return request;
    }

    @Override
    public boolean hasRequestRules() {
        return !this.incomingRules.isEmpty();
    }

    @Override
    public boolean hasLinkRules() {
        return !this.outgoingRules.isEmpty();
    }
}

