/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder;

import ca.krasnay.sqlbuilder.SelectBuilder;
import ca.krasnay.sqlbuilder.SelectCreator;
import java.io.Serializable;

public class UnionSelectCreator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SelectBuilder builder;
    private SelectCreator creator;

    UnionSelectCreator(SelectCreator creator, SelectBuilder builder) {
        this.builder = builder;
        this.creator = creator;
    }

    protected UnionSelectCreator(SelectCreator owner, UnionSelectCreator other) {
        this.builder = other.builder.clone();
        this.creator = owner;
    }

    public UnionSelectCreator clone(SelectCreator owner) {
        return new UnionSelectCreator(owner, this);
    }

    public UnionSelectCreator and(String expr) {
        this.builder.and(expr);
        return this;
    }

    public UnionSelectCreator column(String name) {
        this.builder.column(name);
        return this;
    }

    public UnionSelectCreator column(String name, boolean groupBy) {
        this.builder.column(name, groupBy);
        return this;
    }

    public UnionSelectCreator distinct() {
        this.builder.distinct();
        return this;
    }

    public UnionSelectCreator from(String table) {
        this.builder.from(table);
        return this;
    }

    public UnionSelectCreator groupBy(String expr) {
        this.builder.groupBy(expr);
        return this;
    }

    public UnionSelectCreator having(String expr) {
        this.builder.having(expr);
        return this;
    }

    public UnionSelectCreator join(String join) {
        this.builder.join(join);
        return this;
    }

    public UnionSelectCreator leftJoin(String join) {
        this.builder.leftJoin(join);
        return this;
    }

    public UnionSelectCreator setParameter(String name, Object value) {
        this.creator.setParameter(name, value);
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    public UnionSelectCreator where(String expr) {
        this.builder.where(expr);
        return this;
    }

    public UnionSelectCreator whereEquals(String expr, Object value) {
        String param = this.creator.allocateParameter();
        this.builder.where(expr + " = :" + param);
        this.creator.setParameter(param, value);
        return this;
    }
}

